/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.OrderedStringMap;
import fig.basic.StrUtils;
import fig.servlet.ArgumentException;
import fig.servlet.WebState;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class RequestParams
extends OrderedStringMap {
    public RequestParams() {
    }

    public RequestParams(RequestParams params) {
        super(params);
    }

    public RequestParams(HttpServletRequest request) {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.put(key, request.getParameter(key));
        }
    }

    public String getReq(String key) throws ArgumentException {
        String val = (String)this.get(key);
        if (val == null) {
            throw ArgumentException.missing(key);
        }
        return val;
    }

    public String[] getStringList(String key) {
        String val = (String)this.get(key);
        return StrUtils.split(val, "\t");
    }

    public String[] getStringListReq(String key) throws ArgumentException {
        String val = this.getReq(key);
        return StrUtils.split(val, "\t");
    }

    public boolean getBoolean(String key) {
        return "true".equals(this.get(key));
    }

    public int getInteger(String key, int defaultVal) {
        String val = (String)this.get(key);
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public void dumpToLog() {
        WebState.logs("Request:");
        for (String key : this.keys()) {
            WebState.logs("  " + key + " = '" + (String)this.get(key) + "'");
        }
    }
}

