/*
 * Decompiled with CFR 0.152.
 */
package monaco.mcmc;

import fig.basic.Option;
import java.util.Random;
import monaco.mcmc.MCAlgorithmType;

public class MCAlgorithmOptions {
    @Option
    public MCAlgorithmType algorithm = MCAlgorithmType.SIMPLE_SMC;
    @Option
    public int maxNThreads = 1;
    @Option
    public int nParticles = 100;
    @Option
    public Random samplingRand = new Random(1L);
    @Option
    public double swapProportion = 0.5;
    @Option
    public int nTemperedChains = 1;
    @Option
    public double temperatureGrowFactor = 1.2;
    @Option
    public int generationPerPrintMHPeriod = 1000;

    public double getTemperedExponent(int c) {
        double temperature = Math.pow(this.temperatureGrowFactor, c);
        return 1.0 / temperature;
    }
}

