/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.UnorderedPair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nuts.math.Graph;
import nuts.math.Graphs;
import nuts.util.CollUtils;

public class MutableGraph<V>
implements Graph<V> {
    private static final long serialVersionUID = 1L;
    private final Set<V> vertices = new HashSet<V>();
    private final Set<UnorderedPair<V, V>> edges = new HashSet<UnorderedPair<V, V>>();
    private final Map<V, Set<V>> nbrs = new HashMap<V, Set<V>>();

    public MutableGraph() {
    }

    public MutableGraph(Graph<V> graph) {
        this.addAllEdges(graph);
    }

    public void addAllEdges(Graph<V> graph) {
        this.addAllEdges(Graphs.edgeSet(graph));
    }

    public void addAllEdges(Collection<UnorderedPair<V, V>> edges) {
        for (UnorderedPair<V, V> edge : edges) {
            this.addEdge(edge);
        }
    }

    @Override
    public boolean hasEdge(V node1, V node2) {
        return this.edges.contains(this.key(node1, node2));
    }

    @Override
    public Set<V> nbrs(V node) {
        return Collections.unmodifiableSet(this._nbrs(node));
    }

    private Set<V> _nbrs(V node) {
        return CollUtils.getNoNullSet(this.nbrs, node);
    }

    @Override
    public Set<V> vertexSet() {
        return Collections.unmodifiableSet(this.vertices);
    }

    private UnorderedPair<V, V> key(V node1, V node2) {
        if (!this.vertices.contains(node1) || !this.vertices.contains(node2)) {
            throw new RuntimeException();
        }
        return new UnorderedPair<V, V>(node1, node2);
    }

    public void addEdge(UnorderedPair<V, V> edge) {
        this.addEdge(edge.getFirst(), edge.getSecond());
    }

    public void addEdge(V node1, V node2) {
        this.vertices.add(node1);
        this.vertices.add(node2);
        this.edges.add(this.key(node1, node2));
        this._nbrs(node1).add(node2);
        this._nbrs(node2).add(node1);
    }

    public void removeEdge(V node1, V node2) {
        if (!this.hasEdge(node1, node2)) {
            throw new RuntimeException();
        }
        this.edges.remove(this.key(node1, node2));
        this._nbrs(node1).remove(node2);
        this._nbrs(node2).remove(node1);
    }

    public void addVertex(V node) {
        this.vertices.add(node);
    }

    public void removeVertex(V node) {
        if (!this.vertices.contains(node)) {
            throw new RuntimeException();
        }
        for (V other : this.nbrs(node)) {
            this.removeEdge(node, other);
        }
        this.vertices.remove(node);
    }

    public String toString() {
        return Graphs.toString(this);
    }
}

