/*
 * Decompiled with CFR 0.152.
 */
package nuts.tui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nuts.util.Tree;

public class FancyTreeRenderer {
    private Map<Object, Node> nodes = new HashMap<Object, Node>();
    private Node root;

    public FancyTreeRenderer(Populator pop) {
        pop.setTable(this);
        this.root = this.get(pop.populate());
    }

    public FancyTreeRenderer(Tree tree) {
        this.root = FancyTreeRenderer.convert(tree);
    }

    public static String println(Tree tree) {
        return new FancyTreeRenderer(tree).toString();
    }

    private static <T> Node convert(Tree<T> tree) {
        Node result = new Node(tree.getLabel());
        for (Tree<T> child : tree.getChildren()) {
            result.children.add(FancyTreeRenderer.convert(child));
        }
        return result;
    }

    public String toString() {
        this.root.computeWidth();
        this.root.computeLeftMargins(0);
        StringBuilder builder = new StringBuilder();
        ArrayList<Node> queue = new ArrayList<Node>();
        queue.add(this.root);
        boolean processingRoot = true;
        while (queue.size() > 0) {
            ArrayList<Node> fringe = queue;
            queue = new ArrayList();
            this.nodeNames(fringe, builder, !processingRoot);
            this.nodeEdges(fringe, builder);
            for (Node node : fringe) {
                for (Node child : node.children) {
                    queue.add(child);
                }
            }
            processingRoot = false;
        }
        return this.removeTrailingNewLing(builder.toString());
    }

    private String removeTrailingNewLing(String string) {
        return string.replaceAll("(\\\\s|\\\\n)+$", "");
    }

    public void nodeNames(List<Node> nodes, StringBuilder builder, boolean printTop) {
        StringBuilder lineHoriEdgeBuilder1 = new StringBuilder();
        StringBuilder nodeNameBuilder = new StringBuilder();
        StringBuilder lineHoriEdgeBuilder2 = new StringBuilder();
        int currentCol = 0;
        for (Node node : nodes) {
            this.nCopies(" ", node.leftMargin - currentCol, nodeNameBuilder);
            this.nCopies(" ", node.leftMargin - currentCol, lineHoriEdgeBuilder1);
            this.nCopies(" ", node.leftMargin - currentCol, lineHoriEdgeBuilder2);
            nodeNameBuilder.append(node.contents);
            lineHoriEdgeBuilder1.append("|");
            if (node.children.size() > 0) {
                lineHoriEdgeBuilder2.append("|");
            } else {
                lineHoriEdgeBuilder2.append(" ");
            }
            this.nCopies(" ", node.contents.length() - 1, lineHoriEdgeBuilder1);
            this.nCopies(" ", node.contents.length() - 1, lineHoriEdgeBuilder2);
            currentCol = node.leftMargin + node.contents.length();
        }
        if (printTop) {
            builder.append((CharSequence)lineHoriEdgeBuilder1);
        }
        if (printTop) {
            builder.append("\n");
        }
        builder.append((CharSequence)nodeNameBuilder);
        builder.append("\n");
        builder.append((CharSequence)lineHoriEdgeBuilder2);
        builder.append("\n");
    }

    public void nodeEdges(List<Node> nodes, StringBuilder builder) {
        int currentCol = 0;
        for (Node node : nodes) {
            this.nCopies(" ", node.leftMargin - currentCol, builder);
            for (int i = 0; i < node.children.size(); ++i) {
                if (node.children.size() == 1) {
                    builder.append('|');
                } else {
                    builder.append('+');
                }
                if (i == node.children.size() - 1) continue;
                this.nCopies("-", ((Node)node.children.get(i)).width, builder);
            }
            if (node.children.size() == 0) {
                currentCol = node.leftMargin;
                continue;
            }
            currentCol = ((Node)node.children.get(node.children.size() - 1)).leftMargin + 1;
        }
        builder.append("\n");
    }

    public void nCopies(String original, int n, StringBuilder builder) {
        for (int i = 0; i < n; ++i) {
            builder.append(original);
        }
    }

    private Node get(Object object) {
        Node node = this.nodes.get(object);
        if (node == null) {
            node = new Node(object);
            this.nodes.put(object, node);
        }
        return node;
    }

    public static void main(String[] args) {
        FancyTreeRenderer treeRend = new FancyTreeRenderer(new Populator(){

            @Override
            public Object populate() {
                List<String> strings = Arrays.asList("a", "asdf", "ase", "asdg", "arr", "alm", "aly", "alz", "alya", "alyb", "axx", "asd", "as", "ar", "al", "ax");
                for (String string : strings) {
                    this.add(string, string.length() > 1 ? string.subSequence(0, string.length() - 1) : null);
                }
                return "a";
            }
        });
        System.out.println(treeRend.toString());
    }

    private static class Node {
        private List<Node> children = new ArrayList<Node>();
        private String contents = "";
        private int leftMargin = -1;
        private int width = 0;

        private Node(Object obj) {
            this.contents = obj == null || obj.toString() == null || obj.toString().length() == 0 ? " " : obj.toString();
        }

        private void computeLeftMargins(int currentMargin) {
            this.leftMargin = currentMargin;
            for (Node child : this.children) {
                child.computeLeftMargins(currentMargin);
                currentMargin += child.width + 1;
            }
        }

        private int computeWidth() {
            int result = 0;
            for (Node child : this.children) {
                result += child.computeWidth() + 1;
            }
            this.width = result = Math.max(this.contents.toString().length(), result - 1);
            return result;
        }

        public String toString() {
            return this.contents;
        }
    }

    public static abstract class Populator {
        private FancyTreeRenderer renderer;

        private void setTable(FancyTreeRenderer renderer) {
            this.renderer = renderer;
        }

        public abstract Object populate();

        public final Object add(Object object) {
            this.add(object, null);
            return object;
        }

        public final Object add(Object object, Object parent) {
            Node childNode = this.renderer.get(object);
            if (parent == null) {
                this.renderer.root = childNode;
            } else {
                Node parentNode = this.renderer.get(parent);
                parentNode.children.add(childNode);
            }
            return object;
        }
    }
}

