/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import fig.basic.LogInfo;
import fig.basic.Option;
import java.util.Random;
import nuts.io.IO;
import parallel.Ising;

public class ParallelTempering
implements Runnable {
    @Option
    public int MAX_ITER = 100000;
    @Option
    public int L = 3;
    @Option
    public double p_swap = 0.5;
    @Option
    public double alpha = 0.0;
    public double[] temperatures = new double[]{2.0, 2.5, 3.0, 3.5, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0};
    public Random rand = new Random();

    public static void main(String[] args) {
        IO.run(args, new ParallelTempering());
    }

    @Override
    public void run() {
        Ising[] models = new Ising[this.temperatures.length];
        for (int i = 0; i < this.temperatures.length; ++i) {
            models[i] = new Ising(this.L, this.alpha, this.temperatures[i], 0);
        }
        double u = 0.0;
        double deltaEnergy = 0.0;
        int i = 0;
        int numIter = 0;
        int numSwaps = 0;
        int numTotalIter = 0;
        int numWhite = 0;
        int numBlack = 0;
        do {
            if ((u = this.rand.nextDouble()) < this.p_swap) {
                i = this.rand.nextInt(models.length - 1);
                deltaEnergy = models[i + 1].energy() - models[i].energy();
                deltaEnergy = Math.exp(deltaEnergy * (1.0 / this.temperatures[i] - 1.0 / this.temperatures[i + 1]));
                u = this.rand.nextDouble();
                if (u < deltaEnergy) {
                    models[i].setTemperature(this.temperatures[i + 1]);
                    models[i + 1].setTemperature(this.temperatures[i]);
                    Ising temp = models[i];
                    models[i] = models[i + 1];
                    models[i + 1] = temp;
                    ++numSwaps;
                }
            } else {
                for (i = 0; i < models.length; ++i) {
                    models[i].parallelStep();
                }
                ++numIter;
            }
            if (++numTotalIter % 1000 == 0) {
                StringBuffer sb = new StringBuffer();
                int maxIndex = 0;
                double max = Math.abs(models[0].countSpins());
                sb.append(max);
                sb.append(", ");
                for (int k = 1; k < models.length; ++k) {
                    double spins = Math.abs(models[k].countSpins());
                    sb.append(spins);
                    sb.append(" ");
                    if (!(spins > max)) continue;
                    maxIndex = k;
                    max = spins;
                }
            }
            if (models[0].countSpins() == this.L * this.L) {
                ++numWhite;
                continue;
            }
            if (models[0].countSpins() != -this.L * this.L) continue;
            ++numBlack;
        } while (numTotalIter != this.MAX_ITER);
        LogInfo.logs("Num total iter=" + numTotalIter + " Num iter=" + numIter + " Num swaps=" + numSwaps);
        LogInfo.logs("Num White=" + numWhite + " Num Black=" + numBlack);
        models[0].printPosterior();
    }
}

