/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import pepper.Language;

public class LanguageBank {
    @Option(gloss="Where to store the sufficient statistics of the languages")
    public static String cachePath;
    @Option(gloss="Whether to use the cache to load languages")
    public static boolean readCache;
    @Option(gloss="Maximum number of words to load")
    public static int maxWords;
    private List<Language> languages;

    public void read(List<String> languagePaths) throws IOException {
        this.languages = new ArrayList<Language>();
        for (String languagePath : languagePaths) {
            this.languages.add(this.readLanguageFromDir(languagePath));
        }
    }

    private Language readLanguageFromDir(String dirPath) throws IOException {
        LogInfo.track("readLanguageFromDir(%s)", dirPath);
        String name = new File(dirPath).getName();
        Language language = new Language(name);
        String langCachePath = cachePath + "/" + name;
        if (cachePath != null && readCache && new File(langCachePath).exists()) {
            LogInfo.logs("Reading from cache");
            language.readCache(langCachePath);
        } else {
            for (File filePath : new File(dirPath).listFiles()) {
                LogInfo.logs(filePath);
                if (!this.addFileToLanguage(filePath.toString(), language)) break;
            }
            if (cachePath != null) {
                language.writeCache(langCachePath);
            }
        }
        LogInfo.logss(language);
        LogInfo.end_track();
        return language;
    }

    private boolean addFileToLanguage(String path, Language language) throws IOException {
        String line;
        BufferedReader in = IOUtils.openIn(path);
        while ((line = in.readLine()) != null) {
            String[] tokens;
            for (String token : tokens = line.split(" ")) {
                language.addWordToken(token);
            }
            if (maxWords == -1 || language.getNumWords() < maxWords) continue;
            in.close();
            return false;
        }
        in.close();
        return true;
    }

    public int size() {
        return this.languages.size();
    }

    public Language get(int i) {
        return this.languages.get(i);
    }

    static {
        readCache = true;
        maxWords = -1;
    }
}

