/*
 * Decompiled with CFR 0.152.
 */
package pty.mcmc;

import fig.basic.Option;
import fig.basic.Pair;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import nuts.math.HashGraph;
import nuts.math.Sampling;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import pty.RootedTree;
import pty.UnrootedTree;

public interface ProposalDistribution {
    public Pair<UnrootedTree, Double> propose(UnrootedTree var1, Random var2);

    public String description();

    public static class SubtreePruningRegraftingProposal
    implements ProposalDistribution {
        private final boolean resampleNbrEdges;
        private final double a;
        public UnorderedPair<Taxon, Taxon> selectedEdge = null;
        private UnorderedPair<Taxon, Taxon> lastEdge = null;

        public SubtreePruningRegraftingProposal() {
            this.resampleNbrEdges = false;
            this.a = -1.0;
        }

        public SubtreePruningRegraftingProposal(boolean resampleNbrEdges, double a) {
            this.resampleNbrEdges = resampleNbrEdges;
            this.a = a;
        }

        public UnorderedPair<Taxon, Taxon> getLastEdgePicked() {
            return this.lastEdge;
        }

        @Override
        public Pair<UnrootedTree, Double> propose(UnrootedTree current, Random rand) {
            UnorderedPair<Taxon, Taxon> edge = null;
            edge = this.selectedEdge != null ? this.selectedEdge : current.randomNonTerminalEdge(rand);
            if (edge == null) {
                return null;
            }
            this.lastEdge = edge;
            double edgeBl = current.branchLength(edge);
            Pair<RootedTree, RootedTree> twoRootedTrees = this.divideOneUnrootedTree2twoRootedTrees(current, edge);
            RootedTree secondTree = twoRootedTrees.getSecond();
            UnrootedTree firstTree = UnrootedTree.fromRooted(twoRootedTrees.getFirst());
            List<UnorderedPair<Taxon, Taxon>> allEdges = firstTree.edges();
            int picked = rand.nextInt(allEdges.size());
            UnorderedPair<Taxon, Taxon> regraftEdge = allEdges.get(picked);
            RootedTree.RootingInfo rooting = new RootedTree.RootingInfo(regraftEdge.getFirst(), regraftEdge.getSecond(), edge.getFirst(), rand.nextDouble());
            RootedTree rt = firstTree.reRoot(rooting);
            Taxon regraftNewRoot = new Taxon("regraftNewRoot");
            Arbre<Taxon> newArbre = Arbre.arbreWithChildren(regraftNewRoot, rt.topology(), secondTree.topology());
            List<Arbre<Taxon>> newtreeRootChildren = newArbre.root().getChildren();
            HashMap<Taxon, Double> blMap = CollUtils.map();
            blMap.putAll(rt.branchLengths());
            blMap.putAll(secondTree.branchLengths());
            blMap.put(newtreeRootChildren.get(0).getContents(), edgeBl * 0.5);
            blMap.put(newtreeRootChildren.get(1).getContents(), edgeBl * 0.5);
            RootedTree.Util.RootedTreeImpl regraftRootedTree = new RootedTree.Util.RootedTreeImpl(newArbre, blMap);
            UnrootedTree proposedTree = UnrootedTree.fromRooted(regraftRootedTree);
            double sum = 0.0;
            return Pair.makePair(proposedTree, sum);
        }

        public static UnrootedTree regraft(RootedTree c) {
            HashMap<UnorderedPair<Taxon, Taxon>, Double> branchLengths = new HashMap<UnorderedPair<Taxon, Taxon>, Double>();
            HashSet<Taxon> languages = new HashSet<Taxon>(c.topology().nodeContents());
            HashSet edges = new HashSet();
            for (Arbre<Taxon> node : c.topology().nodes()) {
                if (node.isRoot()) continue;
                UnorderedPair<Taxon, Taxon> edge = null;
                double bl = -1.0;
                if (node.getParent().isRoot() && node.getParent().getChildren().size() == 2) {
                    languages.remove(c.topology().getContents());
                    List<Arbre<Taxon>> parentChildren = node.getParent().getChildren();
                    edge = new UnorderedPair<Taxon, Taxon>(parentChildren.get(0).getContents(), parentChildren.get(1).getContents());
                    bl = c.branchLengths().get(parentChildren.get(0).getContents()) + c.branchLengths().get(parentChildren.get(1).getContents());
                } else {
                    edge = new UnorderedPair<Taxon, Taxon>(node.getContents(), node.getParent().getContents());
                    bl = c.branchLengths().get(node.getContents());
                }
                edges.add(edge);
                branchLengths.put(edge, bl);
            }
            return new UnrootedTree(new HashGraph<Taxon>(languages, edges), branchLengths);
        }

        public Pair<RootedTree, RootedTree> divideOneUnrootedTree2twoRootedTrees(UnrootedTree urt, UnorderedPair<Taxon, Taxon> selectEdge) {
            RootedTree.RootingInfo rooting = new RootedTree.RootingInfo(selectEdge.getFirst(), selectEdge.getSecond(), Taxon.dummy, 0.5);
            RootedTree rt = urt.reRoot(rooting);
            Arbre<Taxon> topo = rt.topology();
            List<Arbre<Taxon>> rootChildren = topo.root().getChildren();
            Arbre<Taxon> trtopo0 = rootChildren.get(0).copy();
            Arbre<Taxon> trtopo1 = rootChildren.get(1).copy();
            Map<Taxon, Double> allbl = rt.branchLengths();
            HashMap<Taxon, Double> subbl0 = CollUtils.map();
            HashMap<Taxon, Double> subbl1 = CollUtils.map();
            for (Taxon tax : trtopo0.nodeContents()) {
                if (tax.equals(trtopo0.getContents())) continue;
                subbl0.put(tax, allbl.get(tax));
            }
            for (Taxon tax : trtopo1.nodeContents()) {
                if (tax.equals(trtopo1.getContents())) continue;
                subbl1.put(tax, allbl.get(tax));
            }
            RootedTree.Util.RootedTreeImpl subtr0 = new RootedTree.Util.RootedTreeImpl(trtopo0, subbl0);
            RootedTree.Util.RootedTreeImpl subtr1 = new RootedTree.Util.RootedTreeImpl(trtopo1, subbl1);
            return Pair.makePair(subtr0, subtr1);
        }

        @Override
        public String description() {
            return "sSPR" + (this.resampleNbrEdges ? "+MB(" + this.a + ")" : "");
        }
    }

    public static class StochasticNearestNeighborInterchangeProposal
    implements ProposalDistribution {
        private final boolean resampleNbrEdges;
        private final double a;
        public UnorderedPair<Taxon, Taxon> selectedEdge = null;
        private UnorderedPair<Taxon, Taxon> lastEdge = null;

        public StochasticNearestNeighborInterchangeProposal() {
            this.resampleNbrEdges = false;
            this.a = -1.0;
        }

        public StochasticNearestNeighborInterchangeProposal(boolean resampleNbrEdges, double a) {
            this.resampleNbrEdges = resampleNbrEdges;
            this.a = a;
        }

        public UnorderedPair<Taxon, Taxon> getLastEdgePicked() {
            return this.lastEdge;
        }

        @Override
        public Pair<UnrootedTree, Double> propose(UnrootedTree current, Random rand) {
            UnorderedPair<Taxon, Taxon> edge = null;
            edge = this.selectedEdge != null ? this.selectedEdge : current.randomNonTerminalEdge(rand);
            if (edge == null) {
                return null;
            }
            this.lastEdge = edge;
            int picked = rand.nextInt(2);
            UnrootedTree proposedTree = current.topologicalNeighbors(edge).get(picked);
            double sum = 0.0;
            if (this.resampleNbrEdges) {
                for (UnorderedPair<Taxon, Taxon> nbrEdge : proposedTree.nbrEdges(edge)) {
                    double lambda = 2.0 * Math.log(this.a);
                    double rvUnif = Sampling.nextDouble(rand, 0.0, 1.0);
                    double m = Math.exp(lambda * (rvUnif - 0.5));
                    Pair<UnrootedTree, Double> p = MultiplicativeBranchProposal.propose(proposedTree, rand, nbrEdge, m);
                    proposedTree = p.getFirst();
                    sum += p.getSecond().doubleValue();
                }
            }
            return Pair.makePair(proposedTree, sum);
        }

        @Override
        public String description() {
            return "sNNI" + (this.resampleNbrEdges ? "+MB(" + this.a + ")" : "");
        }
    }

    public static class MultiplicativeBranchProposal
    implements ProposalDistribution {
        private final double a;
        private final boolean global;
        public UnorderedPair<Taxon, Taxon> selectedEdge = null;

        public MultiplicativeBranchProposal(double a, boolean global) {
            if (a < 1.0) {
                throw new RuntimeException();
            }
            this.global = global;
            this.a = a;
        }

        @Override
        public Pair<UnrootedTree, Double> propose(UnrootedTree current, Random rand) {
            double lambda = 2.0 * Math.log(this.a);
            double rvUnif = Sampling.nextDouble(rand, 0.0, 1.0);
            double m = Math.exp(lambda * (rvUnif - 0.5));
            if (this.global) {
                double sum = 0.0;
                UnrootedTree proposedTree = current;
                for (UnorderedPair<Taxon, Taxon> edge : current.edges()) {
                    rvUnif = Sampling.nextDouble(rand, 0.0, 1.0);
                    m = Math.exp(lambda * (rvUnif - 0.5));
                    Pair<UnrootedTree, Double> p = MultiplicativeBranchProposal.propose(proposedTree, rand, edge, m);
                    proposedTree = p.getFirst();
                    sum += p.getSecond().doubleValue();
                }
                return Pair.makePair(proposedTree, sum);
            }
            if (this.selectedEdge != null) {
                return MultiplicativeBranchProposal.propose(current, rand, this.selectedEdge, m);
            }
            return MultiplicativeBranchProposal.propose(current, rand, current.randomEdge(rand), m);
        }

        public static Pair<UnrootedTree, Double> propose(UnrootedTree current, Random rand, UnorderedPair<Taxon, Taxon> edge, double m) {
            double newBL = m * current.branchLength(edge);
            UnrootedTree proposedTree = current.branchLengthNeighbor(edge, newBL);
            return Pair.makePair(proposedTree, Math.log(m));
        }

        @Override
        public String description() {
            return (this.global ? "g" : "") + "MB(" + this.a + ")";
        }
    }

    public static class IndepBranchProposal
    implements ProposalDistribution {
        @Override
        public String description() {
            return "indepBL";
        }

        @Override
        public Pair<UnrootedTree, Double> propose(UnrootedTree current, Random rand) {
            UnorderedPair<Taxon, Taxon> edge = current.randomEdge(rand);
            double oldVal = current.branchLength(edge);
            double newVal = Sampling.sampleExponential(rand, 1.0);
            double logRatio = Sampling.exponentialLogDensity(1.0, oldVal) - Sampling.exponentialLogDensity(1.0, newVal);
            UnrootedTree proposedTree = current.branchLengthNeighbor(edge, newVal);
            return Pair.makePair(proposedTree, logRatio);
        }
    }

    public static class Util {
        public static final Options _defaultProposalDistributionOptions = new Options();

        public static List<ProposalDistribution> proposalList(Options options, UnrootedTree nct, Random rand) {
            ArrayList<ProposalDistribution> result = new ArrayList<ProposalDistribution>();
            if (options.useMultiplicativeBranchProposal) {
                result.add(new MultiplicativeBranchProposal(options.multiplicativeBranchProposalScaling, false));
            }
            if (options.useGlobalMultiplicativeBranchProposal) {
                result.add(new MultiplicativeBranchProposal(options.multiplicativeBranchProposalScaling, true));
            }
            if (options.useStochasticNearestNeighborInterchangeProposal) {
                result.add(new StochasticNearestNeighborInterchangeProposal());
            }
            if (options.useStochasticNearestNeighborInterchangeProposalWithNbrsResampling) {
                result.add(new StochasticNearestNeighborInterchangeProposal(true, options.multiplicativeBranchProposalScaling));
            }
            if (options.useSubtreePruningRegraftingProposal) {
                result.add(new SubtreePruningRegraftingProposal());
            }
            if (options.useIndepBranchProp) {
                result.add(new IndepBranchProposal());
            }
            Collections.shuffle(result, rand);
            return result;
        }

        public static List<ProposalDistribution> proposalList(Options options, Random rand, double temperature) {
            ArrayList<ProposalDistribution> result = new ArrayList<ProposalDistribution>();
            if (options.useMultiplicativeBranchProposal) {
                result.add(new MultiplicativeBranchProposal(Math.pow(options.multiplicativeBranchProposalScaling, temperature), false));
            }
            if (options.useGlobalMultiplicativeBranchProposal) {
                result.add(new MultiplicativeBranchProposal(Math.pow(options.multiplicativeBranchProposalScaling, temperature), true));
            }
            if (options.useStochasticNearestNeighborInterchangeProposal) {
                result.add(new StochasticNearestNeighborInterchangeProposal());
            }
            if (options.useStochasticNearestNeighborInterchangeProposalWithNbrsResampling) {
                result.add(new StochasticNearestNeighborInterchangeProposal(true, Math.pow(options.multiplicativeBranchProposalScaling, temperature)));
            }
            if (options.useSubtreePruningRegraftingProposal) {
                result.add(new SubtreePruningRegraftingProposal());
            }
            if (options.useIndepBranchProp) {
                result.add(new IndepBranchProposal());
            }
            Collections.shuffle(result, rand);
            return result;
        }
    }

    public static class Options {
        @Option
        public double multiplicativeBranchProposalScaling = 2.0;
        @Option
        public boolean useMultiplicativeBranchProposal = true;
        @Option
        public boolean useGlobalMultiplicativeBranchProposal = true;
        @Option
        public boolean useStochasticNearestNeighborInterchangeProposal = true;
        @Option
        public boolean useStochasticNearestNeighborInterchangeProposalWithNbrsResampling = true;
        @Option
        public boolean useSubtreePruningRegraftingProposal = true;
        @Option
        public boolean useIndepBranchProp = false;
    }
}

