/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.test;

import goblin.BayesRiskMinimizer;
import goblin.DataPrepUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import ma.newick.NewickParser;
import ma.newick.ParseException;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.Arbre;
import nuts.util.Counter;
import nuts.util.Tree;
import pty.eval.SymmetricDiff;

public class ReadMrBayesTrees {
    public static final Pattern selectTranslate = Pattern.compile("\\s*([0-9]+) ([^,]+)[,;]");
    public static final Pattern selectTree = Pattern.compile("\\s*tree rep[.][0-9]+ [=] (.*)$");

    public static void main(String[] args) {
        List<Tree<String>> trees = ReadMrBayesTrees.readTrees(args[0], 10);
        Counter<Set<Set<String>>> clades = new Counter<Set<Set<String>>>();
        for (Tree<String> t : trees) {
            clades.incrementCount(SymmetricDiff.clades(Arbre.tree2Arbre(t)), 1.0);
        }
        Set mbr = (Set)new BayesRiskMinimizer<Set<Set<String>>>(new SymmetricDiff()).findMin(clades);
        System.out.println(DataPrepUtils.newick(Arbre.arbre2Tree(SymmetricDiff.clades2arbre(mbr))));
    }

    public static List<Tree<String>> readTrees(String mrBayesOutputPath) {
        return ReadMrBayesTrees.readTrees(mrBayesOutputPath, 1);
    }

    public static List<Tree<String>> readTrees(String mrBayesOutputPath, int interval) {
        HashMap<String, String> translation = new HashMap<String, String>();
        ArrayList<Tree<String>> trees = new ArrayList<Tree<String>>();
        int n = 0;
        for (String line : IO.i(mrBayesOutputPath)) {
            if (selectTranslate.matcher(line).matches()) {
                List<String> matches = StringUtils.multiSelectFirstRegex(selectTranslate, line);
                translation.put(matches.get(0), matches.get(1));
                continue;
            }
            if (!selectTree.matcher(line).matches() || n++ % interval != 0) continue;
            String treeStr = StringUtils.selectFirstRegex(selectTree, line);
            for (String code : translation.keySet()) {
                for (String s : Arrays.asList("[(]", "[,]")) {
                    treeStr = treeStr.replaceFirst(s + code + ":", s.charAt(1) + (String)translation.get(code) + ":");
                }
            }
            NewickParser np = new NewickParser(treeStr);
            try {
                trees.add(np.parse());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return trees;
    }
}

