/*
 * Decompiled with CFR 0.152.
 */
package slice.ndp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.util.CollUtils;

public class DistributionToken<D> {
    private final List<D> points;
    private final List<Integer> indicators;
    private Map<Integer, Set<D>> inverse;
    private final int truncation;

    public DistributionToken(List<D> points, List<Integer> indicators, int truncation) {
        this.points = CollUtils.archive(points);
        this.indicators = new ArrayList<Integer>();
        this.indicators.addAll(indicators);
        this.truncation = truncation;
        this.refreshInverse();
    }

    private void refreshInverse() {
        this.inverse = new HashMap<Integer, Set<D>>();
        for (int i = 0; i < this.indicators.size(); ++i) {
            int clusterIndex = this.indicators.get(i);
            int dataIndex = i;
            Set<D> set = this.inverse.get(clusterIndex);
            if (set == null) {
                set = new HashSet<D>();
                this.inverse.put(clusterIndex, set);
            }
            set.add(this.points.get(dataIndex));
        }
    }

    public int size() {
        return this.indicators.size();
    }

    public int getIndicators(int i) {
        return this.indicators.get(i);
    }

    public D getPoint(int i) {
        return this.points.get(i);
    }

    public void setIndicators(int i, int value) {
        assert (value >= 0 && value < this.truncation);
        this.indicators.set(i, value);
        this.refreshInverse();
    }

    public Collection<D> membersOfCluster(int l) {
        HashSet result = new HashSet();
        if (this.inverse.get(l) != null) {
            result.addAll(this.inverse.get(l));
        }
        assert (result.equals(this.slowMembersOfCluster(l)));
        return result;
    }

    private Collection<D> slowMembersOfCluster(int l) {
        HashSet<D> result = new HashSet<D>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getIndicators(i) != l) continue;
            result.add(this.getPoint(i));
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int clusterIndex : this.inverse.keySet()) {
            result.append("(" + clusterIndex + " : " + this.membersOfCluster(clusterIndex) + ") ");
        }
        return result.toString();
    }
}

