/*
 * Decompiled with CFR 0.152.
 */
package slice.stickrep;

import java.util.Random;
import slice.stickrep.DPMSample;
import slice.stickrep.Location;
import slice.stickrep.LocationDistribution;

public class DataGenerator<L extends Location<D>, D> {
    private LocationDistribution<L, D> prior;
    private double alpha0;

    public DataGenerator(LocationDistribution<L, D> prior, double alpha0) {
        this.alpha0 = alpha0;
        this.prior = prior;
    }

    public DPMSample<L, D> generateSample(int numberOfDataPoints, Random rand) {
        DPMSample<L, D> sample = new DPMSample<L, D>();
        sample.setAlpha0(this.alpha0);
        for (int i = 0; i < numberOfDataPoints; ++i) {
            double mixSample = rand.nextDouble();
            sample.ensureEnoughSticks(1.0 - mixSample, this.prior, rand);
            int clusterIndex = sample.getSticks().retreiveIndex(mixSample);
            sample.getIndicators().add(clusterIndex);
            sample.getData().add(((Location)sample.getLocationParams().get(clusterIndex)).sample(rand));
        }
        return sample;
    }
}

