/*
 * Decompiled with CFR 0.152.
 */
package smc;

import ev.ex.GetPhylogeneticKernel;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import nuts.io.IO;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import smc.DistributedSMC;

public class PhyloDistributedSMC
implements Runnable {
    @Option(required=true)
    public int nTax;
    @Option(required=true)
    public int nSites;
    @Option(required=true)
    public int N;
    @Option(required=true)
    public int numMachines;
    @Option(required=true)
    public DistributedSMC.ParticleOptimizationStyle particleOptimizationStyle;
    @Option(required=true)
    public int numRuns;

    public static void main(String[] args) {
        IO.run(args, new PhyloDistributedSMC());
    }

    @Override
    public void run() {
        int[][] machineConfig = new int[this.numMachines][2];
        int numParticlesPerMachine = this.N / this.numMachines;
        for (int k = 0; k < this.numMachines; ++k) {
            machineConfig[k][0] = numParticlesPerMachine;
            machineConfig[k][1] = numParticlesPerMachine;
        }
        ParticleKernel<PartialCoalescentState> kernel = GetPhylogeneticKernel.getPhyloKernel(this.nTax, this.nSites);
        PartialCoalescentProcessor processor = new PartialCoalescentProcessor();
        int totalNext = 0;
        double totalMax = 0.0;
        double totalMean = 0.0;
        for (int i = 0; i < this.numRuns; ++i) {
            LogInfo.logs("Iteration=" + i);
            DistributedSMC<PartialCoalescentState> dSMC = DistributedSMC.runDistributedSMC(this.nTax - 1, this.N, kernel, machineConfig, processor, this.particleOptimizationStyle);
            Pair<Double, Double> stat = dSMC.getStats();
            double max = stat.getFirst();
            double mean = stat.getSecond();
            int nexts = dSMC.getNexts();
            LogInfo.logs("max=" + max + ", mean=" + mean + ", next=" + nexts);
            totalMax += max;
            totalMean += mean;
            totalNext += nexts;
        }
        LogInfo.logs("Next=" + (double)totalNext / (double)this.numRuns);
        LogInfo.logs("Max=" + totalMax / (double)this.numRuns);
        LogInfo.logs("Mean=" + totalMean / (double)this.numRuns);
    }

    public static class PartialCoalescentProcessor
    implements ParticleFilter.ParticleProcessor<PartialCoalescentState> {
        @Override
        public void process(PartialCoalescentState state, double weight) {
        }
    }
}

