/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.ImportScanner;

public class ImportScannerImpl
extends CtScanner
implements ImportScanner {
    private Map<String, CtTypeReference<?>> imports = new TreeMap();

    @Override
    public <T> void visitCtFieldAccess(CtFieldAccess<T> f) {
        this.enter(f);
        this.scan(f.getVariable());
        this.scan(f.getAnnotations());
        this.scanReferences(f.getTypeCasts());
        this.scan(f.getVariable());
        this.scan((CtElement)f.getTarget());
        this.exit(f);
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.enter(f);
        this.scan(f.getVariable());
        this.scan(f.getAnnotations());
        this.scanReferences(f.getTypeCasts());
        this.scan(f.getVariable());
        this.scan((CtElement)f.getTarget());
        this.exit(f);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        this.enterReference(reference);
        this.scan(reference.getDeclaringType());
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.enterReference(reference);
        if (reference.getDeclaringType() != null && reference.getDeclaringType().getDeclaringType() == null) {
            this.addImport(reference.getDeclaringType());
        }
        this.scanReferences(reference.getActualTypeArguments());
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.scan((CtElement)invocation.getTarget());
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        if (!(reference instanceof CtArrayTypeReference)) {
            if (reference.getDeclaringType() == null) {
                this.addImport(reference);
            } else {
                this.addImport(reference.getDeclaringType());
            }
        }
        super.visitCtTypeReference(reference);
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.addImport(annotationType.getReference());
        super.visitCtAnnotationType(annotationType);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.addImport(ctEnum.getReference());
        super.visitCtEnum(ctEnum);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.addImport(intrface.getReference());
        for (CtType<?> t : intrface.getNestedTypes()) {
            this.addImport(t.getReference());
        }
        super.visitCtInterface(intrface);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.addImport(ctClass.getReference());
        for (CtType<?> t : ctClass.getNestedTypes()) {
            this.addImport(t.getReference());
        }
        super.visitCtClass(ctClass);
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        for (CtTypeReference<?> type : catchVariable.getMultiTypes()) {
            this.addImport(type);
        }
        super.visitCtCatchVariable(catchVariable);
    }

    @Override
    public Collection<CtTypeReference<?>> computeImports(CtType<?> simpleType) {
        this.addImport(simpleType.getReference());
        this.scan(simpleType);
        return this.getImports(simpleType);
    }

    @Override
    public void computeImports(CtElement element) {
        this.scan(element);
    }

    @Override
    public boolean isImported(CtTypeReference<?> ref) {
        CtTypeReference<?> exist;
        return this.imports.containsKey(ref.getSimpleName()) && (exist = this.imports.get(ref.getSimpleName())).getQualifiedName().equals(ref.getQualifiedName());
    }

    private Collection<CtTypeReference<?>> getImports(CtType<?> simpleType) {
        if (this.imports.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        CtPackageReference pack = this.imports.get(simpleType.getSimpleName()).getPackage();
        ArrayList refs = new ArrayList();
        for (CtTypeReference<?> ref : this.imports.values()) {
            if (ref.getPackage() == null || ref.getPackage().getSimpleName().equals("java.lang") || ref.getPackage().getSimpleName().equals(pack.getSimpleName())) continue;
            refs.add(ref);
        }
        return Collections.unmodifiableCollection(refs);
    }

    private boolean addImport(CtTypeReference<?> ref) {
        if (this.imports.containsKey(ref.getSimpleName())) {
            return this.isImported(ref);
        }
        this.imports.put(ref.getSimpleName(), ref);
        return true;
    }
}

