/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.sdi.SDIR;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class sdi_r {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String MIN_MAPPING_COST_OPTION = "ml";
    private static final String MIN_DUPS_OPTION = "md";
    private static final String MIN_HEIGHT_OPTION = "mh";
    private static final String PRG_NAME = "sdi_r";
    private static final String PRG_VERSION = "1.11";
    private static final String PRG_DATE = "2009.06.19";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org";
    private static final int TREES_TO_RETURN = 5;

    public static void main(String[] stringArray) {
        PhyloXmlParser phyloXmlParser;
        File file;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2) || stringArray.length == 0) {
            sdi_r.printHelp();
            System.exit(0);
        }
        if (stringArray.length < 3 || commandLineArguments.getNumberOfNames() != 2) {
            System.out.println();
            System.out.println("[sdi_r] incorrect number of arguments");
            System.out.println();
            sdi_r.printHelp();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(MIN_MAPPING_COST_OPTION);
        arrayList.add(MIN_DUPS_OPTION);
        arrayList.add(MIN_HEIGHT_OPTION);
        String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
        }
        if ((file = new File("sdir_outfile.xml")).exists()) {
            ForesterUtil.fatalError(PRG_NAME, "outfile \"" + file + "\" already exists");
        }
        File file2 = commandLineArguments.getFile(0);
        File file3 = commandLineArguments.getFile(1);
        boolean bl = false;
        if (commandLineArguments.isOptionSet(MIN_MAPPING_COST_OPTION)) {
            bl = true;
        }
        boolean bl2 = false;
        if (commandLineArguments.isOptionSet(MIN_DUPS_OPTION)) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (commandLineArguments.isOptionSet(MIN_HEIGHT_OPTION)) {
            bl3 = true;
        }
        int n = 0;
        Phylogeny[] phylogenyArray = null;
        Phylogeny phylogeny = null;
        if (bl && bl2) {
            bl2 = false;
        }
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        try {
            phyloXmlParser = new PhyloXmlParser();
            phylogeny = phylogenyFactory.create(file3, phyloXmlParser)[0];
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read species tree [" + file3 + "]: " + iOException.getLocalizedMessage());
        }
        if (!phylogeny.isRooted()) {
            ForesterUtil.fatalError(PRG_NAME, "species tree [" + file3 + "] is not rooted");
        }
        try {
            phyloXmlParser = new PhyloXmlParser();
            phylogenyArray = phylogenyFactory.create(file2, phyloXmlParser);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read gene trees [" + file2 + "]: " + iOException.getLocalizedMessage());
        }
        int n2 = 0;
        ArrayList<Phylogeny> arrayList2 = new ArrayList<Phylogeny>();
        for (Phylogeny phylogeny2 : phylogenyArray) {
            n = PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(phylogeny, phylogeny2);
            ForesterUtil.programMessage(PRG_NAME, "Removed " + n + " external nodes from gene tree");
            SDIR sDIR = new SDIR();
            long l = new Date().getTime();
            Phylogeny[] phylogenyArray2 = null;
            try {
                phylogenyArray2 = sDIR.infer(phylogeny2, phylogeny, bl, bl2, bl3, true, 5);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getLocalizedMessage());
            }
            long l2 = new Date().getTime() - l;
            if (bl) {
                ForesterUtil.programMessage(PRG_NAME, "Rooted by minimizing mapping cost L");
                if (bl3) {
                    ForesterUtil.programMessage(PRG_NAME, "Selected tree(s) with minimal height out of resulting trees");
                }
                ForesterUtil.programMessage(PRG_NAME, "Number differently rooted trees minimizing criterion  : " + sDIR.getCount());
                ForesterUtil.programMessage(PRG_NAME, "Minimal cost                                          : " + sDIR.getMinimalMappingCost());
                ForesterUtil.programMessage(PRG_NAME, "Minimal duplications                                  : " + sDIR.getMinimalDuplications());
                if (bl3) {
                    ForesterUtil.programMessage(PRG_NAME, "Phylogeny height                                      : " + ForesterUtil.FORMATTER_06.format(sDIR.getMinimalTreeHeight()));
                    ForesterUtil.programMessage(PRG_NAME, "Difference in subtree heights                         : " + ForesterUtil.FORMATTER_06.format(sDIR.getMinimalDiffInSubTreeHeights()));
                }
            } else if (bl2) {
                ForesterUtil.programMessage(PRG_NAME, "Rooted by minimizing sum of duplications");
                if (bl3) {
                    ForesterUtil.programMessage(PRG_NAME, "Selected tree(s) with minimal height out of resulting trees");
                }
                ForesterUtil.programMessage(PRG_NAME, "Number differently rooted trees minimizing criterion        : " + sDIR.getCount());
                ForesterUtil.programMessage(PRG_NAME, "Minimal duplications                                        : " + sDIR.getMinimalDuplications());
                if (bl3) {
                    ForesterUtil.programMessage(PRG_NAME, "Phylogeny height                                            : " + ForesterUtil.FORMATTER_06.format(sDIR.getMinimalTreeHeight()));
                    ForesterUtil.programMessage(PRG_NAME, "Difference in subtree heights                               : " + ForesterUtil.FORMATTER_06.format(sDIR.getMinimalDiffInSubTreeHeights()));
                }
            } else if (bl3) {
                ForesterUtil.programMessage(PRG_NAME, "Rooted by minimizing tree height (midpoint rooting).");
                ForesterUtil.programMessage(PRG_NAME, "Minimal tree height                  : " + ForesterUtil.FORMATTER_06.format(sDIR.getMinimalTreeHeight()));
                ForesterUtil.programMessage(PRG_NAME, "Minimal difference in subtree heights: " + ForesterUtil.FORMATTER_06.format(sDIR.getMinimalDiffInSubTreeHeights()));
                ForesterUtil.programMessage(PRG_NAME, "Duplications in midpoint rooted tree : " + sDIR.getMinimalDuplications());
            } else {
                ForesterUtil.programMessage(PRG_NAME, "No (re) rooting was performed.");
                ForesterUtil.programMessage(PRG_NAME, "Duplications in tree: " + sDIR.getMinimalDuplications());
            }
            ForesterUtil.programMessage(PRG_NAME, "Time requirement (minus I/O)                          : " + l2 + "ms");
            for (int i = 0; i < phylogenyArray2.length; ++i) {
                String string2 = phylogenyArray2[i].getName();
                if (ForesterUtil.isEmpty(string2)) {
                    phylogenyArray2[i].setName("SDIR result [gene tree + " + n2 + "]" + " " + i);
                } else {
                    phylogenyArray2[i].setName(string2 + " SDIR result [gene tree + " + n2 + "]" + " " + i);
                }
                arrayList2.add(phylogenyArray2[i]);
            }
            ++n2;
        }
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(file, arrayList2, 0, ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failure to write output to [" + file + "]: " + iOException.getLocalizedMessage());
        }
        ForesterUtil.programMessage(PRG_NAME, "Wrote: " + file);
        ForesterUtil.programMessage(PRG_NAME, "OK.");
    }

    private static void printHelp() {
        System.out.println("Usage: sdi_r <options> <gene tree(s) in phyloXML format> <species tree in phyloXML format>\"");
        System.out.println("\nOptions:");
        System.out.println(" -ml to root by minimizing the mapping cost L (and also the sum of duplications)");
        System.out.println(" -md to root by minimizing the sum of duplications");
        System.out.println(" -mh to root by minimizing tree height (can be used together with -ml or -md)");
        System.out.println("");
    }
}

