/*
 * Decompiled with CFR 0.152.
 */
package JSci.astro.telescope;

import JSci.astro.telescope.LX200Remote;
import java.io.IOException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public final class LX200DebugServer
extends UnicastRemoteObject
implements LX200Remote {
    private String ra = "00:00:00";
    private String dec = "+00*00'00";

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: LX200DebugServer <remote name>");
            return;
        }
        System.setSecurityManager(new RMISecurityManager());
        try {
            Registry registry = LocateRegistry.createRegistry(1099);
            registry.rebind(stringArray[0], new LX200DebugServer());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setFocusRate(int n) throws IOException, RemoteException {
        System.err.println("setFocusRate: " + n);
    }

    public void startFocus(int n) throws IOException, RemoteException {
        System.err.println("startFocus: " + n);
    }

    public void stopFocus() throws IOException, RemoteException {
        System.err.println("stopFocus");
    }

    public void setSlewRate(int n) throws IOException, RemoteException {
        System.err.println("setSlewRate: " + n);
    }

    public void startSlew(int n) throws IOException, RemoteException {
        System.err.println("startSlew: " + n);
    }

    public void stopSlew(int n) throws IOException, RemoteException {
        System.err.println("stopSlew: " + n);
    }

    public String getRA() throws IOException, RemoteException {
        System.err.println("getRA");
        return this.ra;
    }

    public String getDec() throws IOException, RemoteException {
        System.err.println("getDec");
        return this.dec;
    }

    public void setObjectCoords(String string, String string2) throws IOException, RemoteException {
        System.err.println("setObjectCoords: " + string + ", " + string2);
        this.ra = string;
        this.dec = string2;
    }

    public int slewToObject() throws IOException, RemoteException {
        System.err.println("slewToObject");
        return 0;
    }

    public void syncCoords() throws IOException, RemoteException {
        System.err.println("syncCoords");
    }
}

