/*
 * Decompiled with CFR 0.152.
 */
package cognates;

import cognates.LanguageTreeNode;
import fig.basic.Indexer;
import nuts.math.TabularGMFct;
import org.apache.commons.math3.linear.RealMatrix;

public class Peeling {
    private int site;
    private RealMatrix P;
    private Indexer<Character> phonemes;
    private TabularGMFct<LanguageTreeNode> pot;
    public static double CONST_LIKELIHOOD;

    public Peeling(int site, RealMatrix P, Indexer<Character> phonemes) {
        this.site = site;
        this.phonemes = phonemes;
        this.P = P;
        CONST_LIKELIHOOD = 1.0 / (double)phonemes.size();
    }

    public void setPotential(LanguageTreeNode node) {
        char ch = node.getSequence(this.site);
        int y = this.phonemes.indexOf(Character.valueOf(ch));
        for (int z = 0; z < this.phonemes.size(); ++z) {
            if (y == z) {
                this.pot.set(node, z, CONST_LIKELIHOOD);
                continue;
            }
            this.pot.set(node, z, 0.0);
        }
    }

    public void computePotential(LanguageTreeNode left, LanguageTreeNode right, int branch) {
        double[] leftLik = this.pot.get(left);
        double[] rightLik = this.pot.get(right);
        int B = leftLik.length;
        LanguageTreeNode parent = new LanguageTreeNode(left, right);
        for (int z = 0; z < B; ++z) {
            double lik = 0.0;
            for (int y = 0; y < B; ++y) {
                double p = this.getTransitionProb(z, y, branch);
                this.pot.set(left, parent, z, y, p);
                this.pot.set(right, parent, z, y, p);
                lik += leftLik[y] * p * (rightLik[y] * p);
            }
            this.pot.set(parent, z, lik);
        }
    }

    private double getTransitionProb(int z, int y, int branch) {
        RealMatrix PP = this.P.power(branch);
        double prob = PP.getEntry(z, y);
        return prob;
    }

    public static double[][] peel(double[][] child, RealMatrix P) {
        int S = child.length;
        int B = child[0].length;
        double[][] parent = new double[S][B];
        for (int s = 0; s < S; ++s) {
            parent[s] = Peeling.computeParentLik(child[s], P);
        }
        return parent;
    }

    public static double[] computeParentLik(double[] child, RealMatrix P) {
        int numPhonemes = child.length;
        double[] parent = new double[numPhonemes];
        for (int z = 0; z < numPhonemes; ++z) {
            parent[z] = 0.0;
            for (int y = 0; y < numPhonemes; ++y) {
                int n = z;
                parent[n] = parent[n] + P.getEntry(z, y) * child[y];
            }
        }
        return parent;
    }
}

