/*
 * Decompiled with CFR 0.152.
 */
package conifer.particle;

import conifer.Phylogeny;
import java.io.File;
import nuts.io.IO;
import nuts.io.OutputProducer;
import nuts.io.SimpleOutputProducer;

public interface TreeProvider {
    public Phylogeny getTree();

    public static class SingletonTreeProvider
    implements TreeProvider,
    OutputProducer {
        public final Phylogeny p;
        private SimpleOutputProducer output = new SimpleOutputProducer();

        public SingletonTreeProvider(Phylogeny p) {
            this.p = p;
        }

        @Override
        public Phylogeny getTree() {
            File f = new File(this.output.getOutputFolder(), "tree.newick");
            IO.writeToDisk(f, this.p.getUnrooted().toNewick());
            return this.p;
        }

        @Override
        public void setOutputFolder(File f) {
            this.output.setOutputFolder(f);
        }
    }
}

