/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

public class SparseMatrixExponential {
    public static int maxKrylovBasisSize = 50;
    public static double tolerance = 1.0E-7;
    private int order;
    private int nonZeroEntries;
    private int krylovBasisSize;
    private double[] workSpace;
    private int[] intWorkSpace;
    private int lengthWorkspace;
    private int lengthIntWorkspace;
    private int[] fortranIndexX;
    private int[] fortranIndexY;
    private double[] rate;
    private double[] start;
    private double[] stop;
    private double norm;
    int index = 0;

    private native void executeDGEXPV(int var1, int var2, int var3, double var4, double[] var6, double[] var7, double var8, double var10, double[] var12, int[] var13, int[] var14, double[] var15, int var16, int[] var17, int var18, int var19);

    public SparseMatrixExponential(int order, int nonZeroEntries) {
        this.order = order;
        this.nonZeroEntries = nonZeroEntries;
        this.setUpWorkspace();
    }

    private void setUpWorkspace() {
        this.krylovBasisSize = this.order < maxKrylovBasisSize ? this.order - 10 : maxKrylovBasisSize - 1;
        this.lengthIntWorkspace = this.krylovBasisSize + 2;
        this.lengthWorkspace = this.order * this.lengthIntWorkspace + 5 * this.lengthIntWorkspace * this.lengthIntWorkspace + 7;
        this.intWorkSpace = new int[this.lengthIntWorkspace];
        this.workSpace = new double[this.lengthWorkspace];
        this.start = new double[this.order];
        this.stop = new double[this.order];
        this.fortranIndexX = new int[this.nonZeroEntries];
        this.fortranIndexY = new int[this.nonZeroEntries];
        this.rate = new double[this.nonZeroEntries];
    }

    public void addEntry(int i, int j, double value) {
        this.fortranIndexX[this.index] = i + 1;
        this.fortranIndexY[this.index] = j + 1;
        this.rate[this.index] = value;
        ++this.index;
    }

    public void setNorm(double norm) {
        this.norm = norm;
    }

    public void calculateInfinityNorm() {
    }

    public double getExponentialEntry(int x, int y, double time) {
        this.start[x] = 1.0;
        int flag = 0;
        this.executeDGEXPV(this.order, this.nonZeroEntries, this.krylovBasisSize, time, this.start, this.stop, tolerance, this.norm, this.rate, this.fortranIndexX, this.fortranIndexY, this.workSpace, this.lengthWorkspace, this.intWorkSpace, this.lengthIntWorkspace, flag);
        this.start[x] = 0.0;
        return this.stop[y];
    }

    public String sparseRepresentation() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.order + " " + this.nonZeroEntries + "\n");
        for (int i = 0; i < this.nonZeroEntries; ++i) {
            sb.append(this.fortranIndexX[i]);
            sb.append(" ");
            sb.append(this.fortranIndexY[i]);
            sb.append(" ");
            sb.append(this.rate[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        System.loadLibrary("ExpoKit");
    }
}

