/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.ChiSquareDistribution;
import dr.math.distributions.Distribution;
import dr.math.distributions.GammaDistribution;
import dr.math.distributions.NormalDistribution;
import dr.math.interfaces.OneVariableFunction;
import dr.math.iterations.BisectionZeroFinder;
import dr.math.iterations.NewtonZeroFinder;

public class InverseGaussianDistribution
implements Distribution {
    private UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return InverseGaussianDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    protected double m;
    protected double sd;
    protected double shape;

    public InverseGaussianDistribution(double mean, double shape) {
        this.m = mean;
        this.shape = shape;
        this.sd = InverseGaussianDistribution.calculateSD(mean, shape);
    }

    public double getMean() {
        return this.m;
    }

    public void setMean(double value) {
        this.m = value;
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double value) {
        this.shape = value;
        this.sd = InverseGaussianDistribution.calculateSD(this.m, this.shape);
    }

    public static double calculateSD(double mean, double shape) {
        return Math.sqrt(mean * mean * mean / shape);
    }

    @Override
    public double pdf(double x) {
        return InverseGaussianDistribution.pdf(x, this.m, this.shape);
    }

    @Override
    public double logPdf(double x) {
        return InverseGaussianDistribution.logPdf(x, this.m, this.shape);
    }

    @Override
    public double cdf(double x) {
        return InverseGaussianDistribution.cdf(x, this.m, this.shape);
    }

    @Override
    public double quantile(double y) {
        return InverseGaussianDistribution.quantile(y, this.m, this.shape);
    }

    @Override
    public double mean() {
        return InverseGaussianDistribution.mean(this.m, this.shape);
    }

    @Override
    public double variance() {
        return InverseGaussianDistribution.variance(this.m, this.shape);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double x, double m, double shape) {
        double a = Math.sqrt(shape / (Math.PI * 2 * x * x * x));
        double b = -shape * (x - m) * (x - m) / (2.0 * m * m * x);
        return a * Math.exp(b);
    }

    public static double logPdf(double x, double m, double shape) {
        double a = Math.sqrt(shape / (Math.PI * 2 * x * x * x));
        double b = -shape * (x - m) * (x - m) / (2.0 * m * m * x);
        return Math.log(a) + b;
    }

    public static double cdf(double x, double m, double shape) {
        if (x <= 0.0 || m <= 0.0 || shape <= 0.0) {
            return Double.NaN;
        }
        double a = Math.sqrt(shape / x);
        double b = x / m;
        double p1 = NormalDistribution.cdf(a * (b - 1.0), 0.0, 1.0, false);
        double p2 = NormalDistribution.cdf(-a * (b + 1.0), 0.0, 1.0, false);
        if (p2 == 0.0) {
            return p1;
        }
        double c = 2.0 * shape / m;
        if (c >= Double.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        return p1 + Math.exp(c) * p2;
    }

    public static double quantile(double z, double m, double shape) {
        double initialGuess;
        if (z < 0.01 || z > 0.99) {
            throw new RuntimeException("Quantile is too low/high to calculate (numerical estimation for extreme values is incomplete");
        }
        if (shape / m > 2.0) {
            initialGuess = (NormalDistribution.quantile(z, 0.0, 1.0) - 0.5 * Math.sqrt(m / shape)) / Math.sqrt(shape / m);
            initialGuess = m * Math.exp(initialGuess);
        } else {
            initialGuess = shape / (GammaDistribution.quantile(1.0 - z, 0.5, 1.0) * 2.0);
            if (initialGuess > m / 2.0) {
                initialGuess = m * Math.exp(GammaDistribution.quantile(z, 0.5, 1.0) * 0.1);
            }
        }
        final InverseGaussianDistribution f = new InverseGaussianDistribution(m, shape);
        final double y = z;
        NewtonZeroFinder zeroFinder = new NewtonZeroFinder(new OneVariableFunction(){

            @Override
            public double value(double x) {
                return f.cdf(x) - y;
            }
        }, initialGuess);
        zeroFinder.evaluate();
        if (Double.isNaN(zeroFinder.getResult()) || zeroFinder.getPrecision() > 5.0E-6) {
            zeroFinder = new NewtonZeroFinder(new OneVariableFunction(){

                @Override
                public double value(double x) {
                    return f.cdf(x) - y;
                }
            }, initialGuess);
            zeroFinder.initializeIterations();
            double previousPrecision = 0.0;
            double previousResult = Double.NaN;
            double max = 10000.0;
            double min = 1.0E-5;
            for (int i = 0; i < 50; ++i) {
                zeroFinder.evaluateIteration();
                double precision = f.cdf(zeroFinder.getResult()) - z;
                if (previousPrecision > 0.0 && precision < 0.0 || previousPrecision < 0.0 && precision > 0.0) {
                    max = Math.max(previousResult, zeroFinder.getResult());
                    min = Math.min(previousResult, zeroFinder.getResult());
                    max = Math.min(10000.0, max);
                    break;
                }
                previousPrecision = precision;
                previousResult = zeroFinder.getResult();
            }
            return InverseGaussianDistribution.calculateZeroFinderApproximation(z, m, shape, min, max, initialGuess);
        }
        return zeroFinder.getResult();
    }

    private static double calculateZeroFinderApproximation(double z, double m, double shape, double min, double max, double initialGuess) {
        final InverseGaussianDistribution f = new InverseGaussianDistribution(m, shape);
        final double y = z;
        BisectionZeroFinder bisectionZeroFinder = new BisectionZeroFinder(new OneVariableFunction(){

            @Override
            public double value(double x) {
                return f.cdf(x) - y;
            }
        }, min, max);
        bisectionZeroFinder.setInitialValue(initialGuess);
        bisectionZeroFinder.initializeIterations();
        double bestValue = Double.NaN;
        double bestPrecision = 10.0;
        double precision = 10.0;
        double previousPrecision = 10.0;
        int count = 0;
        while (precision > 0.001 && count < 10) {
            bisectionZeroFinder.evaluateIteration();
            precision = Math.abs(f.cdf(bisectionZeroFinder.getResult()) - z);
            if (precision < bestPrecision) {
                bestPrecision = precision;
                bestValue = bisectionZeroFinder.getResult();
            } else if (previousPrecision == precision) {
                ++count;
            }
            previousPrecision = precision;
        }
        bisectionZeroFinder.finalizeIterations();
        return bestValue;
    }

    private static double calculateShiftedGammaApproximation(double z, double m, double shape) {
        double a = 3.0 * m * m / (4.0 * shape);
        double b = m / 3.0;
        double nu = 8.0 * shape / (9.0 * m);
        return a * ChiSquareDistribution.quantile(z, nu) + b;
    }

    private static double calculateShiftedGammaApproximationWithRIG(double z, double m, double shape) {
        double a = (3.0 * shape + 8.0 * m) / (4.0 * shape * (shape + 2.0 * m));
        double b = (shape + 3.0 * m) / (m * (3.0 * shape + 8.0 * m));
        double nu = 8.0 * Math.pow(shape + 2.0 * m, 3.0) / (m * Math.pow(8.0 * m + 3.0 * shape, 2.0));
        double y_hat = a * ChiSquareDistribution.quantile(z, nu) + b;
        return 1.0 / y_hat;
    }

    private static double calculateZeroFinderApproximation(double z, double m, double shape, int numIterations, double min, double max) {
        final InverseGaussianDistribution f = new InverseGaussianDistribution(m, shape);
        final double y = z;
        BisectionZeroFinder bisectionZeroFinder = new BisectionZeroFinder(new OneVariableFunction(){

            @Override
            public double value(double x) {
                return f.cdf(x) - y;
            }
        }, min, max);
        bisectionZeroFinder.setMaximumIterations(numIterations);
        bisectionZeroFinder.evaluate();
        return bisectionZeroFinder.getResult();
    }

    public static double mean(double m, double shape) {
        return m;
    }

    public static double variance(double m, double shape) {
        double sd = InverseGaussianDistribution.calculateSD(m, shape);
        return sd * sd;
    }
}

