/*
 * Decompiled with CFR 0.152.
 */
package dr.math.iterations;

import dr.math.functionEval.DrMath;
import dr.math.functionEval.FunctionDerivative;
import dr.math.interfaces.OneVariableFunction;
import dr.math.iterations.FunctionalIterator;

public class NewtonZeroFinder
extends FunctionalIterator {
    private OneVariableFunction df;

    public NewtonZeroFinder(OneVariableFunction func, double start) {
        super(func);
        this.setStartingValue(start);
    }

    public NewtonZeroFinder(OneVariableFunction func, OneVariableFunction dFunc, double start) throws IllegalArgumentException {
        this(func, start);
        this.setDerivative(dFunc);
    }

    @Override
    public double evaluateIteration() {
        double delta = this.f.value(this.result) / this.df.value(this.result);
        this.result -= delta;
        return this.relativePrecision(Math.abs(delta));
    }

    @Override
    public void initializeIterations() {
        if (this.df == null) {
            this.df = new FunctionDerivative(this.f);
        }
        if (Double.isNaN(this.result)) {
            this.result = 0.0;
        }
        int n = 0;
        while (DrMath.equal(this.df.value(this.result), 0.0) && ++n <= this.getMaximumIterations()) {
            this.result += Math.random();
        }
    }

    public void setDerivative(OneVariableFunction dFunc) throws IllegalArgumentException {
        this.df = new FunctionDerivative(this.f);
        if (!DrMath.equal(this.df.value(this.result), dFunc.value(this.result), 0.001)) {
            throw new IllegalArgumentException("Supplied derative function is inaccurate");
        }
        this.df = dFunc;
    }

    @Override
    public void setFunction(OneVariableFunction func) {
        super.setFunction(func);
        this.df = null;
    }

    public void setStartingValue(double start) {
        this.result = start;
    }
}

