/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;

public class LinearEquations {
    private double[][] rows;
    private Vector[] solutions;

    public LinearEquations(double[][] m, double[][] c) throws IllegalDimension {
        int n = m.length;
        if (m[0].length != n) {
            throw new IllegalDimension("Illegal system: a" + n + " by " + m[0].length + " matrix is not a square matrix");
        }
        if (c[0].length != n) {
            throw new IllegalDimension("Illegal system: a " + n + " by " + n + " matrix cannot build a system with a " + c[0].length + "-dimensional vector");
        }
        this.rows = new double[n][n + c.length];
        for (int i = 0; i < n; ++i) {
            int j;
            for (j = 0; j < n; ++j) {
                this.rows[i][j] = m[i][j];
            }
            for (j = 0; j < c.length; ++j) {
                this.rows[i][n + j] = c[j][i];
            }
        }
    }

    public LinearEquations(double[][] m, double[] c) throws IllegalDimension {
        int n = m.length;
        if (m[0].length != n) {
            throw new IllegalDimension("Illegal system: a" + n + " by " + m[0].length + " matrix is not a square matrix");
        }
        if (c.length != n) {
            throw new IllegalDimension("Illegal system: a " + n + " by " + n + " matrix cannot build a system with a " + c.length + "-dimensional vector");
        }
        this.rows = new double[n][n + 1];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.rows[i][j] = m[i][j];
            }
            this.rows[i][n] = c[i];
        }
    }

    public LinearEquations(Matrix a, Vector y) throws IllegalDimension {
        this(a.components, y.components);
    }

    private void backSubstitution(int p) throws ArithmeticException {
        int n = this.rows.length;
        double[] answer = new double[n];
        for (int i = n - 1; i >= 0; --i) {
            double x = this.rows[i][n + p];
            for (int j = i + 1; j < n; ++j) {
                x -= answer[j] * this.rows[i][j];
            }
            answer[i] = x / this.rows[i][i];
        }
        this.solutions[p] = new Vector(answer);
    }

    private int largestPivot(int p) {
        double pivot = Math.abs(this.rows[p][p]);
        int answer = p;
        for (int i = p + 1; i < this.rows.length; ++i) {
            double x = Math.abs(this.rows[i][p]);
            if (!(x > pivot)) continue;
            answer = i;
            pivot = x;
        }
        return answer;
    }

    private void pivot(int p) throws ArithmeticException {
        double inversePivot = 1.0 / this.rows[p][p];
        int n = this.rows.length;
        int m = this.rows[0].length;
        for (int i = p + 1; i < n; ++i) {
            double r = inversePivot * this.rows[i][p];
            for (int j = p; j < m; ++j) {
                double[] dArray = this.rows[i];
                int n2 = j;
                dArray[n2] = dArray[n2] - this.rows[p][j] * r;
            }
        }
    }

    private void pivotingStep(int p) {
        this.swapRows(p, this.largestPivot(p));
        this.pivot(p);
    }

    public Vector solution() throws ArithmeticException {
        return this.solution(0);
    }

    public Vector solution(int p) throws ArithmeticException {
        if (this.solutions == null) {
            this.solve();
        }
        if (this.solutions[p] == null) {
            this.backSubstitution(p);
        }
        return this.solutions[p];
    }

    private void solve() throws ArithmeticException {
        int n = this.rows.length;
        for (int i = 0; i < n; ++i) {
            this.pivotingStep(i);
        }
        this.solutions = new Vector[this.rows[0].length - n];
    }

    private void swapRows(int p, int q) {
        if (p != q) {
            int m = this.rows[p].length;
            for (int j = 0; j < m; ++j) {
                double temp = this.rows[p][j];
                this.rows[p][j] = this.rows[q][j];
                this.rows[q][j] = temp;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        char[] separator = new char[]{'[', ' '};
        int n = this.rows.length;
        int m = this.rows[0].length;
        for (int i = 0; i < n; ++i) {
            int j;
            separator[0] = 40;
            for (j = 0; j < n; ++j) {
                sb.append(separator);
                sb.append(this.rows[i][j]);
                separator[0] = 44;
            }
            separator[0] = 58;
            for (j = n; j < m; ++j) {
                sb.append(separator);
                sb.append(this.rows[i][j]);
                separator[0] = 44;
            }
            sb.append(')');
            sb.append('\n');
        }
        return sb.toString();
    }
}

