/*
 * Decompiled with CFR 0.152.
 */
package ev.poi.exp;

import java.util.List;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.Counter;

public class ReadSyntheticExperiments {
    public static void main(String[] args) {
        String treeFile = args[0];
        String alignFile = args[1];
        Counter<String> identity = new Counter<String>();
        Counter<String> rf = new Counter<String>();
        for (List<String> line : IO.iCSV(treeFile)) {
            if (line.get(0).charAt(0) == '#') {
                if (line.get(1).equals("metric") && line.get(2).equals("score")) continue;
                throw new RuntimeException("Format seems to be invalid");
            }
            if (!line.get(1).equals("NormalizedRobinsonFouldsMetric")) continue;
            rf.setCount(line.get(0), Double.parseDouble(line.get(2)));
        }
        for (List<String> line : IO.iCSV(alignFile)) {
            if (line.get(0).charAt(0) == '#') {
                if (line.get(5).equals("ref-notes")) continue;
                throw new RuntimeException("Format seems to be invalid");
            }
            identity.setCount(line.get(0), Double.parseDouble(StringUtils.selectFirstRegex(".*IdentityFraction=([^,]*),.*", line.get(5))));
        }
        if (!identity.keySet().equals(rf.keySet())) {
            throw new RuntimeException();
        }
        for (String key : identity.keySet()) {
            IO.so("" + identity.getCount(key) + "\t" + rf.getCount(key));
        }
    }
}

