/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import fig.basic.LogInfo;
import fig.basic.Option;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ma.MSAParser;
import ma.MSAPoset;
import ma.MultiAlignment;
import nuts.io.IO;

public class Clust {
    @Option
    public static boolean useProbCons = false;
    @Option
    public static ArrayList<String> clustalPaths = new ArrayList<String>(Arrays.asList("/Users/bouchard/Documents/bin/clustalw-2.0.12-macosx/clustalw2", "/home/eecs/bouchard/bin/clustalw-2.0.12-linux-i686-libcppstatic/clustalw2"));
    @Option
    public static ArrayList<String> probconsPaths = new ArrayList<String>(Arrays.asList("/home/eecs/bouchard/bin/probcons"));

    public static File clustal(File dataDirectory, String suffixFilter) {
        File outputDir = IO.getTempDir("temp-clustalw2");
        outputDir.mkdir();
        for (File f : IO.ls(dataDirectory, suffixFilter)) {
            String basename = IO.nameWithoutExtension(f);
            LogInfo.track((Object)("Processing " + basename), true);
            try {
                File output = new File(outputDir, basename + ".msf");
                MultiAlignment inputAlign = MSAParser.parseMSA(f).toMultiAlignmentObject();
                MultiAlignment result = Clust.clustal(inputAlign);
                result.saveToMSF(output);
            }
            catch (Exception e) {
                LogInfo.warning("Failed on " + f);
            }
            LogInfo.end_track();
        }
        return outputDir;
    }

    private static void _callClustal(File input, File output) {
        if (useProbCons) {
            String result = IO.call(Clust.getFirstValidPath(probconsPaths) + " " + input.getAbsolutePath());
            String[] lines = result.split("\n");
            StringBuilder builder = new StringBuilder();
            boolean found = false;
            for (String line : lines) {
                if (line.length() > 0 && line.charAt(0) == '>') {
                    found = true;
                }
                if (!found) continue;
                builder.append(line + '\n');
            }
            IO.writeToDisk(output, builder.toString());
            MSAPoset msa = MSAPoset.parseFASTA(output);
            msa.toMultiAlignmentObject().saveToMSF(output);
        } else {
            IO.call(Clust.getFirstValidPath(clustalPaths) + " -infile=" + input.getAbsolutePath() + " -outfile=" + output.getAbsolutePath() + " -output=gcg");
        }
    }

    public static MultiAlignment clustal(MultiAlignment toConvertToFasta) {
        try {
            File input = File.createTempFile("" + System.currentTimeMillis(), "fasta");
            File out = File.createTempFile("" + System.currentTimeMillis() + 1, "msf");
            IO.writeToDisk(input, MultiAlignment.toFASTA(toConvertToFasta));
            Clust._callClustal(input, out);
            return MultiAlignment.parseMSFToMultiAlignment(out.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        IO.run(args, new ClustMain(), "clust", Clust.class);
    }

    public static String getFirstValidPath(List<String> list) {
        for (String s : list) {
            if (!new File(s).exists()) continue;
            return s;
        }
        throw new RuntimeException("None of the files in the list exists:" + list);
    }

    public static class ClustMain
    implements Runnable {
        @Option(required=true)
        public String dataDir;
        @Option
        public String suffixFilter = null;

        @Override
        public void run() {
            Clust.clustal(new File(this.dataDir), this.suffixFilter);
        }
    }
}

