/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.IOUtils;
import fig.exec.servlet.ValueProcessor;
import fig.exec.servlet.WebState;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FieldsSpec
implements Iterable<Info> {
    private List<Info> infos = new ArrayList<Info>();

    public FieldsSpec(String path) {
        try {
            String line;
            BufferedReader in = IOUtils.openIn(path);
            Info info = null;
            while ((line = in.readLine()) != null) {
                String[] tokens;
                if (line.length() == 0) {
                    if (info != null) {
                        this.infos.add(info);
                    }
                    info = null;
                    continue;
                }
                if (line.charAt(0) == '#' || (tokens = line.split("=", 2)).length != 2) continue;
                if (info == null) {
                    info = new Info();
                }
                info.contribute(tokens[0], tokens[1]);
            }
            if (info != null) {
                this.infos.add(info);
            }
        }
        catch (IOException e) {
            WebState.logs("FieldsSpec: error loading " + path);
        }
    }

    @Override
    public Iterator<Info> iterator() {
        return this.infos.iterator();
    }

    public static class Info {
        private String name;
        private String gloss;
        private String data;
        private boolean numeric;
        private ValueProcessor processor;

        public String getName() {
            return this.name;
        }

        public String getGloss() {
            return this.gloss;
        }

        public String getData() {
            return this.data;
        }

        public boolean getNumeric() {
            return this.numeric;
        }

        public ValueProcessor getProcessor() {
            return this.processor;
        }

        public void contribute(String key, String value) {
            if (key.equals("name")) {
                this.name = value;
            } else if (key.equals("gloss")) {
                this.gloss = value;
            } else if (key.equals("data")) {
                this.data = value;
            } else if (key.equals("numeric")) {
                this.numeric = Boolean.parseBoolean(value);
            } else if (key.equals("process")) {
                this.processor = new ValueProcessor(value);
            }
        }
    }
}

