/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.MapUtils;
import fig.basic.TDoubleMap;
import fig.prob.SuffStats;

public class SparseMultinomialSuffStats
extends TDoubleMap
implements SuffStats {
    private double totalCount = 0.0;
    public static final SparseMultinomialSuffStats emptyStats = new SparseMultinomialSuffStats();

    public SparseMultinomialSuffStats() {
    }

    public SparseMultinomialSuffStats(TDoubleMap map) {
        this.incrMap(map, 1.0);
        this.totalCount += map.sum();
    }

    public static SparseMultinomialSuffStats singleton(Object key) {
        SparseMultinomialSuffStats stats = new SparseMultinomialSuffStats();
        stats.put(key, 1.0);
        stats.totalCount = 1.0;
        return stats;
    }

    @Override
    public void add(SuffStats _stats) {
        SparseMultinomialSuffStats stats = (SparseMultinomialSuffStats)_stats;
        this.incrMap(stats, 1.0);
        this.totalCount += stats.totalCount;
    }

    @Override
    public void sub(SuffStats _stats) {
        SparseMultinomialSuffStats stats = (SparseMultinomialSuffStats)_stats;
        this.incrMap(stats, -1.0);
        this.totalCount -= stats.totalCount;
    }

    public SuffStats reweight(double scale) {
        SparseMultinomialSuffStats stats = new SparseMultinomialSuffStats();
        stats.incrMap(this, scale);
        return stats;
    }

    public double getCount(Object o) {
        return this.get(o, 0.0);
    }

    public double totalCount() {
        return this.totalCount;
    }

    @Override
    public String toString() {
        return String.format("Mult(%s)", MapUtils.topNToString(this, 20));
    }
}

