/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.BigStatFig;
import fig.basic.Exceptions;
import fig.basic.IOUtils;
import fig.basic.ListUtils;
import fig.basic.MapUtils;
import fig.basic.NumUtils;
import fig.basic.StrUtils;
import fig.record.ArgsParser;
import fig.record.Mandate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class GnuPlotter {
    private TimeSeries timeSeries = new TimeSeries();
    private Scatter scatter = new Scatter();
    private Histogram histogram = new Histogram();

    public TimeSeries getTimeSeries() {
        return this.timeSeries;
    }

    public Scatter getScatter() {
        return this.scatter;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public void reset() {
        this.timeSeries.reset();
        this.scatter.reset();
        this.histogram.reset();
    }

    public Mandate makeMandate(boolean cleanup) {
        Mandate mandate = new Mandate(cleanup);
        mandate.addMandate(this.timeSeries.makeMandate(cleanup));
        mandate.addMandate(this.scatter.makeMandate(cleanup));
        mandate.addMandate(this.histogram.makeMandate(cleanup));
        return mandate;
    }

    private static List makeScanLines(List<Point> points, boolean is3D) {
        if (!is3D) {
            return points;
        }
        ArrayList<Object> newList = new ArrayList<Object>();
        double lastx = Double.NaN;
        for (Point point : points) {
            if (!Double.isNaN(lastx) && !NumUtils.equals(point.x, lastx)) {
                newList.add("");
            }
            newList.add(point);
            lastx = point.x;
        }
        return newList;
    }

    public static class TimeSeries
    extends Plot {
        @Override
        public boolean addPoint(String key, double value) {
            List list = MapUtils.getListMut(this.points, key);
            return this.addPoint(key, list.size(), value);
        }

        @Override
        protected String getCommand(String plot, String key, String file) {
            return String.format("%s \"%s\" with %s title \"%s\"", plot, file, this.getWithStyle(), key);
        }
    }

    public static class Histogram
    extends Plot {
        private int numBuckets = 100;

        public void setNumBuckets(int numBuckets) {
            this.numBuckets = numBuckets;
        }

        @Override
        protected List<Point> processPoints(List<Point> points, double minx, double maxx) {
            ArrayList<Point> histPoints = new ArrayList<Point>(this.numBuckets + 2);
            for (int i = -1; i <= this.numBuckets; ++i) {
                histPoints.add(new Point((maxx - minx) * ((double)i + 0.5) / (double)this.numBuckets + minx, 0.0));
            }
            for (Point p : points) {
                int i = (int)((p.x - minx) / (maxx - minx) * (double)this.numBuckets);
                if (i < 0) {
                    throw new RuntimeException("Out of bounds: " + p.x + " = x < min = " + minx);
                }
                if (i == this.numBuckets) {
                    i = this.numBuckets - 1;
                }
                ((Point)histPoints.get((int)(i + 1))).y += 1.0;
            }
            if (this.normalize) {
                for (Point p : histPoints) {
                    p.y /= (double)points.size();
                }
            }
            return histPoints;
        }

        @Override
        public boolean addPoint(String key, double value) {
            return this.addPoint(key, value, 0.0);
        }

        @Override
        protected String getCommand(String plot, String key, String file) {
            return String.format("%s \"%s\" with lines title \"%s\"", plot, file, key);
        }
    }

    public static class Scatter
    extends Plot {
        @Override
        protected String getCommand(String plot, String key, String file) {
            return String.format("%s \"%s\" with %s title \"%s\"", plot, file, this.getWithStyle(), key);
        }
    }

    public static abstract class Plot {
        protected LinkedHashMap<String, List<Point>> points = new LinkedHashMap();
        public String title;
        public String xlabel;
        public String ylabel;
        public String zlabel;
        public String outPath;
        public boolean withLines = true;
        public boolean withPoints = true;
        public boolean withErrors = false;
        public boolean withDots = false;
        public boolean normalize = false;
        public String appendPath = null;
        public int lineWidth = 1;
        public int pointSize = 1;
        public int titleFontSize = 14;
        public int labelFontSize = 10;
        public double rightExpandFrac = 0.0;
        public String prependCommand;
        public String appendCommand;
        public static final String[] propertyNames = new String[]{"title", "xlabel", "ylabel", "zlabel", "lines", "points", "errors", "dots", "out", "normalize", "append", "titleFontSize", "labelFontSize", "lineWidth", "pointSize", "rightExpandFrac", "prepend", "append"};

        public int dim() {
            for (List<Point> list : this.points.values()) {
                Iterator<Point> iterator = list.iterator();
                if (!iterator.hasNext()) continue;
                Point p = iterator.next();
                return p.dim();
            }
            return -1;
        }

        protected String getWithStyle() {
            String style = this.withErrors ? (this.withLines ? "yerrorlines" : "errorbars") : (this.withDots ? "dots" : (this.withLines ? "lines" : "") + (this.withPoints ? "points" : ""));
            if (this.withLines) {
                style = style + " linewidth " + this.lineWidth;
            }
            if (this.withPoints) {
                style = style + " pointsize " + this.pointSize;
            }
            return style;
        }

        public boolean addPoint(String key, double x) {
            throw Exceptions.unsupported;
        }

        public boolean addPoint(String key, double x, double y) {
            if (!NumUtils.isFinite(x) || !NumUtils.isFinite(y)) {
                return false;
            }
            List<Point> list = MapUtils.getListMut(this.points, key);
            list.add(new Point(x, y));
            return true;
        }

        public boolean addPoint(String key, double x, double y, double z) {
            if (!(NumUtils.isFinite(x) && NumUtils.isFinite(y) && NumUtils.isFinite(z))) {
                return false;
            }
            List<Point> list = MapUtils.getListMut(this.points, key);
            list.add(new Point(x, y, z));
            return true;
        }

        public boolean addPoint(String key, double x, double y, double z, double w) {
            if (!(NumUtils.isFinite(x) && NumUtils.isFinite(y) && NumUtils.isFinite(z) && NumUtils.isFinite(w))) {
                return false;
            }
            List<Point> list = MapUtils.getListMut(this.points, key);
            list.add(new Point(x, y, z, w));
            return true;
        }

        public void reset() {
            this.points.clear();
        }

        protected List<Point> processPoints(List<Point> points, double minx, double maxx) {
            return points;
        }

        protected abstract String getCommand(String var1, String var2, String var3);

        private void setVar(List<String> plotCmds, String var, String ... values) {
            plotCmds.add("set " + var + " " + StrUtils.join(values));
        }

        private static String font(int size) {
            return "font \"Helvetica," + size + "\"";
        }

        private static String quote(String s) {
            return "\"" + s + "\"";
        }

        public void setProperties(ArgsParser parser) {
            this.title = parser.get("title", this.title);
            this.xlabel = parser.get("xlabel", this.xlabel);
            this.ylabel = parser.get("ylabel", this.ylabel);
            this.zlabel = parser.get("zlabel", this.zlabel);
            this.withLines = parser.getBoolean("lines", this.withLines);
            this.withPoints = parser.getBoolean("points", this.withPoints);
            this.withErrors = parser.getBoolean("errors", this.withErrors);
            this.withDots = parser.getBoolean("dots", this.withDots);
            this.outPath = parser.get("out", this.outPath);
            this.normalize = parser.getBoolean("normalize", this.normalize);
            this.appendPath = parser.get("append", this.appendPath);
            this.titleFontSize = parser.getInt("titleFontSize", this.titleFontSize);
            this.labelFontSize = parser.getInt("labelFontSize", this.labelFontSize);
            this.lineWidth = parser.getInt("lineWidth", this.lineWidth);
            this.pointSize = parser.getInt("pointSize", this.pointSize);
            this.rightExpandFrac = parser.getDouble("rightExpandFrac", this.rightExpandFrac);
            this.prependCommand = parser.get("prepend", this.prependCommand);
            this.appendCommand = parser.get("append", this.appendCommand);
        }

        public Mandate makeMandate(boolean cleanup) {
            Mandate mandate = new Mandate(cleanup);
            if (this.points.size() == 0) {
                return mandate;
            }
            int i = 0;
            ArrayList<String> plotCmds = new ArrayList<String>();
            if (!StrUtils.isEmpty(this.prependCommand)) {
                plotCmds.add(this.prependCommand);
            }
            int dim = this.dim();
            BigStatFig xfig = new BigStatFig();
            BigStatFig yfig = new BigStatFig();
            for (String key : this.points.keySet()) {
                for (Point p : this.points.get(key)) {
                    xfig.add(p.x);
                    yfig.add(p.y);
                    if (!this.withErrors) continue;
                    if (dim == 3) {
                        yfig.add(p.y - p.z);
                        yfig.add(p.y + p.z);
                        continue;
                    }
                    yfig.add(p.z);
                    yfig.add(p.w);
                }
            }
            double f = 0.02;
            double g = 1.0E-10;
            plotCmds.add(String.format("set xrange [%s:%s]", xfig.getMin() - 0.02 * xfig.range() - 1.0E-10, xfig.getMax() + (0.02 + this.rightExpandFrac) * xfig.range() + 1.0E-10));
            if (!(this instanceof Histogram)) {
                plotCmds.add(String.format("set yrange [%s:%s]", yfig.getMin() - 0.02 * yfig.range() - 1.0E-10, yfig.getMax() + 0.02 * yfig.range() + 1.0E-10));
            }
            if (this.title != null) {
                this.setVar(plotCmds, "title", Plot.quote(this.title), Plot.font(this.titleFontSize));
            }
            if (this.xlabel != null) {
                this.setVar(plotCmds, "xlabel", Plot.quote(this.xlabel), Plot.font(this.labelFontSize));
            }
            if (this.ylabel != null) {
                this.setVar(plotCmds, "ylabel", Plot.quote(this.ylabel), Plot.font(this.labelFontSize));
            }
            if (this.zlabel != null) {
                this.setVar(plotCmds, "zlabel", Plot.quote(this.zlabel), Plot.font(this.labelFontSize));
            }
            if (!StrUtils.isEmpty(this.outPath)) {
                if (this.outPath.endsWith(".jpg")) {
                    plotCmds.add("set term jpeg");
                } else if (this.outPath.endsWith(".pdf")) {
                    plotCmds.add("set term pdf");
                } else {
                    plotCmds.add("set term postscript enhanced color");
                }
                this.setVar(plotCmds, "output", Plot.quote(this.outPath));
            }
            if (this.appendPath != null) {
                plotCmds.addAll(IOUtils.readLinesHard(this.appendPath));
            }
            if (!StrUtils.isEmpty(this.appendCommand)) {
                plotCmds.add(this.appendCommand);
            }
            boolean is3D = this.dim() == 3 && !this.withErrors;
            for (String key : this.points.keySet()) {
                String datPath = mandate.tempifyFileName("plot" + i + ".dat");
                List<Point> keyPoints = this.points.get(key);
                if (keyPoints.size() == 0) continue;
                String plot = is3D ? "splot" : "plot";
                mandate.addFile(new Mandate.FileBundle(datPath, GnuPlotter.makeScanLines(this.processPoints(keyPoints, xfig.getMin(), xfig.getMax()), is3D), false));
                String cmd = this.getCommand(i == 0 ? plot : "  ", key, datPath) + (i < this.points.size() - 1 ? ", \\" : "");
                plotCmds.add(cmd);
                ++i;
            }
            String gnuplotPath = mandate.tempifyFileName("all.gnuplot");
            mandate.addFile(new Mandate.FileBundle(gnuplotPath, plotCmds, true));
            String shPath = mandate.tempifyFileName("run.sh");
            String logPath = mandate.tempifyFileName("run.log");
            String cleanupPath = mandate.tempifyFileName("cleanup.sh");
            if (is3D && StrUtils.isEmpty(this.outPath)) {
                mandate.setCleanup(false);
                mandate.addFile(new Mandate.FileBundle(shPath, ListUtils.newList("export DISPLAY=:0", "(xterm -e 'gnuplot -persist " + gnuplotPath + " -' && sh " + cleanupPath + ") &"), true));
                mandate.addCommand("sh " + shPath + " &> " + logPath);
                ArrayList<String> cleanupCmds = new ArrayList<String>();
                if (cleanup) {
                    cleanupCmds.add("rm " + cleanupPath);
                    for (Mandate.FileBundle file : mandate.getFiles()) {
                        cleanupCmds.add("rm " + file.path);
                    }
                    cleanupCmds.add("rm " + logPath);
                    cleanupCmds.add("rmdir " + mandate.tempifyFileName(null));
                }
                mandate.addFile(new Mandate.FileBundle(cleanupPath, cleanupCmds, true));
            } else {
                mandate.addFile(new Mandate.FileBundle(shPath, ListUtils.newList("export DISPLAY=:0", "gnuplot -persist " + gnuplotPath), true));
                mandate.addCommand("sh " + shPath + " &> " + logPath);
                mandate.addCommand("rm " + logPath);
            }
            return mandate;
        }
    }

    private static class Point {
        public double x;
        public double y;
        public double z;
        public double w;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
            this.z = Double.NaN;
            this.w = Double.NaN;
        }

        public Point(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = Double.NaN;
        }

        public Point(double x, double y, double z, double w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }

        public int dim() {
            if (Double.isNaN(this.y)) {
                return 1;
            }
            if (Double.isNaN(this.z)) {
                return 2;
            }
            if (Double.isNaN(this.w)) {
                return 3;
            }
            return 4;
        }

        public String toString() {
            if (Double.isNaN(this.y)) {
                return "" + this.x;
            }
            if (Double.isNaN(this.z)) {
                return "" + this.x + " " + this.y;
            }
            if (Double.isNaN(this.w)) {
                return "" + this.x + " " + this.y + " " + this.z;
            }
            return this.x + " " + this.y + " " + this.z + " " + this.w;
        }
    }
}

