/*
 * Decompiled with CFR 0.152.
 */
package gep.data;

import fig.basic.Option;
import gep.data.DataSource;
import gep.timeseries.Measurements;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nuts.io.IO;
import nuts.util.CollUtils;
import nuts.util.Indexer;

public class MSData
implements DataSource {
    @Option
    public String dataFile = "";
    @Option
    public double timeScale = 1.0;
    private List<Measurements> _data = null;
    private int pointer = 0;
    private Set<String> _possibleObs;

    private void ensureLoaded(Indexer<String> indexer) {
        if (this._data != null) {
            return;
        }
        this._data = CollUtils.list();
        int index = 0;
        ArrayList<Double> times = CollUtils.list();
        ArrayList<Integer> values = CollUtils.list();
        for (String line : IO.i(this.dataFile)) {
            if (index % 2 == 0) {
                for (String item : line.split("\\s+")) {
                    if (item.equals("NA")) continue;
                    double cur = Double.parseDouble(item);
                    times.add(cur / this.timeScale);
                }
            } else {
                for (String item : line.split("\\s+")) {
                    if (item.equals("NA")) continue;
                    if (item.length() != 1) {
                        throw new RuntimeException();
                    }
                    int currentIdx = indexer.o2i("" + item.charAt(0));
                    values.add(currentIdx);
                }
                Measurements currentM = new Measurements(times, values);
                this._data.add(currentM);
                times = CollUtils.list();
                values = CollUtils.list();
            }
            ++index;
        }
    }

    @Override
    public Measurements next(Indexer<String> indexer) {
        this.ensureLoaded(indexer);
        if (this.pointer++ < this._data.size()) {
            return this._data.get(this.pointer - 1);
        }
        return null;
    }

    @Override
    public Set<String> possibleObservations() {
        if (this._possibleObs == null) {
            this.createSet();
        }
        return this._possibleObs;
    }

    private void createSet() {
        this._possibleObs = CollUtils.set();
        this._possibleObs.add("1");
        this._possibleObs.add("2");
        this._possibleObs.add("3");
    }
}

