/*
 * Decompiled with CFR 0.152.
 */
package monaco.prop;

import fig.basic.NumUtils;
import fig.basic.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import monaco.prop.ProposalCombination;
import monaco.prop.ProposalProvider;
import monaco.prop.RepeatedProposalProvider;
import nuts.util.CollUtils;

public abstract class AbstractProposalOptions<S> {
    @Option
    public ArrayList<Double> weights = new ArrayList<Double>(Arrays.asList(1.0));
    @Option(gloss="Leave empty to ignore, otherwise specify the rates of geometric distributions (0 for dirac on 1)")
    public ArrayList<Double> repeatRates = new ArrayList();

    public abstract List<ProposalProvider<S>> getProviders();

    public ProposalProvider<S> getProposalCombination() {
        List<ProposalProvider<S>> providers = this.getProviders();
        if (providers.size() != this.weights.size()) {
            throw new RuntimeException();
        }
        double[] probabilities = new double[this.weights.size()];
        for (int i = 0; i < probabilities.length; ++i) {
            probabilities[i] = this.weights.get(i);
        }
        NumUtils.normalize(probabilities);
        providers = AbstractProposalOptions.processRepeats(providers, this.repeatRates);
        return new ProposalCombination<S>(providers, probabilities);
    }

    private static <S> List<ProposalProvider<S>> processRepeats(List<ProposalProvider<S>> providers, ArrayList<Double> repeats) {
        if (repeats == null || repeats.size() == 0) {
            return providers;
        }
        if (repeats.size() != providers.size()) {
            throw new RuntimeException();
        }
        ArrayList<ProposalProvider<S>> result = CollUtils.list();
        for (int i = 0; i < providers.size(); ++i) {
            double currentRepeatRate = repeats.get(i);
            if (currentRepeatRate == 1.0) {
                result.add(providers.get(i));
                continue;
            }
            result.add(new RepeatedProposalProvider<S>(providers.get(i), currentRepeatRate));
        }
        return result;
    }
}

