/*
 * Decompiled with CFR 0.152.
 */
package nuts.db;

import java.io.File;
import nuts.db.SimpleDatabase;

public class CreateDatabase {
    private final SimpleDatabase db;
    private final File f;

    public CreateDatabase(File f) {
        this.f = f;
        this.db = new SimpleDatabase(f);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("One argument: path to db");
            return;
        }
        File f = new File(args[0]);
        CreateDatabase cd = new CreateDatabase(f);
        cd.create();
    }

    private void create() {
        if (this.f.exists()) {
            System.err.println("File already exists");
            return;
        }
        this.db.update("CREATE TABLE data ( id INTEGER IDENTITY, text_value VARCHAR(10000), int_value INTEGER, double_value DOUBLE PRECISION)");
        this.db.update("CREATE TABLE asso ( data_id INTEGER, gp_id INTEGER)");
        this.db.update("CREATE TABLE tag_gp ( id INTEGER IDENTITY, tag_id INTEGER)");
        this.db.update("CREATE TABLE tag ( id INTEGER IDENTITY, type_id INTEGER, text_value VARCHAR(256), int_value INTEGER, double_value DOUBLE PRECISION)");
        this.db.update("CREATE TABLE type ( id INTEGER IDENTITY, text_value VARCHAR(256))");
        this.db.shutdown();
    }
}

