/*
 * Decompiled with CFR 0.152.
 */
package nuts.remote;

import fig.basic.LogInfo;
import fig.basic.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nuts.io.IO;
import nuts.remote.LaunchLargeExperiment;
import nuts.util.CollUtils;
import nuts.util.EasyFormat;
import nuts.util.RemoteUtils;

public class GetRemoteResults
implements Runnable {
    public static RemoteResultsOptions optionsInstance = null;

    public static void main(String[] args) {
        optionsInstance = new RemoteResultsOptions();
        IO.run(args, new GetRemoteResults(), "opt", optionsInstance);
    }

    @Override
    public void run() {
        ArrayList<String> remoteCmd = GetRemoteResults.optionsInstance.killAfterDownload ? new ArrayList<String>() : null;
        RemoteResultsOptions optionsInstance = GetRemoteResults.optionsInstance;
        optionsInstance.init();
        File destination = optionsInstance.getLocalFolder();
        destination.mkdir();
        List<String> _remoteFiles = optionsInstance.getRemoteDirs();
        ArrayList<String> filteredRemoteFiles = CollUtils.list();
        Set<String> completed = this.completedExecNames(_remoteFiles);
        for (String remoteFile : _remoteFiles) {
            String execName = new File(remoteFile).getName();
            if (!completed.contains(execName)) {
                filteredRemoteFiles.add(remoteFile);
            }
            if (remoteCmd == null) continue;
            remoteCmd.add("touch " + optionsInstance.remotePrefix + "/" + remoteFile + "/kill");
        }
        if (remoteCmd != null) {
            RemoteUtils.remoteBash(optionsInstance.getHost(), remoteCmd);
        }
        if (filteredRemoteFiles.size() > 0) {
            RemoteUtils.fastScp(optionsInstance.getHost(), optionsInstance.remotePrefix, filteredRemoteFiles, destination);
        }
        completed = this.completedExecNames(_remoteFiles);
        LogInfo.logs("Percent execs completed: " + EasyFormat.fmt(100.0 * ((double)completed.size() / (double)_remoteFiles.size())) + "%");
        if (completed.size() == _remoteFiles.size() || optionsInstance.killAfterDownload) {
            File execDir = new File(optionsInstance.launchExec);
            List<String> before = IO.f2l(LaunchLargeExperiment.LAUNCH_EXECS);
            ArrayList<String> after = CollUtils.list();
            for (String line : before) {
                if (execDir.getName().equals(new File(line).getName())) continue;
                after.add(line);
            }
            IO.writeToDisk(LaunchLargeExperiment.LAUNCH_EXECS, after);
        }
    }

    public Set<String> completedExecNames(List<String> remoteFiles) {
        HashSet<String> result = CollUtils.set();
        block0: for (String remoteDir : remoteFiles) {
            String execName = new File(remoteDir).getName();
            File local = new File(optionsInstance.getLocalFolder(), execName);
            File status = new File(local, "output.map");
            if (!status.exists()) continue;
            for (String line : IO.i(status)) {
                String[] fields = line.split("\\s+");
                if (fields.length != 2 || !fields[0].equals("exec.status") || !fields[1].equals("done")) continue;
                result.add(execName);
                continue block0;
            }
        }
        return result;
    }

    public static class RemoteResultsOptions {
        @Option
        public File downloadPool = new File("state", "remote");
        @Option
        public String host = "";
        @Option
        public String remotePrefix = "";
        @Option
        public File execList = null;
        @Option
        public String launchExec = "";
        @Option
        public boolean killAfterDownload = false;

        public void init() {
            if (!(this.host.equals("") ^ this.launchExec.equals(""))) {
                throw new RuntimeException();
            }
            if (this.host.equals("")) {
                File execDir = new File(this.launchExec);
                this.execList = new File(execDir, "remote-execs");
                for (String line : IO.i(new File(execDir, "options.map"))) {
                    String[] fields = line.split("\\s+");
                    if (fields.length < 2) continue;
                    if (fields[0].equals("LaunchLargeExperiment.remoteDirectory")) {
                        this.remotePrefix = fields[1] + "/state/execs/";
                    }
                    if (!fields[0].equals("LaunchLargeExperiment.remoteHost")) continue;
                    this.host = fields[1];
                }
            }
        }

        public String getHost() {
            return this.host;
        }

        public File getLocalFolder() {
            this.downloadPool.mkdir();
            return this.downloadPool;
        }

        public List<File> localExecCopies() {
            return null;
        }

        public List<String> getRemoteDirs() {
            ArrayList<String> remoteDirs = CollUtils.list();
            for (String curRemoteExec : IO.i(this.execList)) {
                remoteDirs.add(new File(curRemoteExec).getName());
            }
            return remoteDirs;
        }
    }
}

