/*
 * Decompiled with CFR 0.152.
 */
package pedi;

import fig.basic.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.util.CollUtils;
import pedi.Individual;
import pedi.Pedigree;
import pedi.SimplePedigree;

public class RegularPedigree
implements Pedigree {
    private final Pedigree p;
    private final Set<Individual> founders;
    private final Set<Individual> leaves;
    private Map<Pair<Individual, Individual>, List<Individual>> marriages;
    private Map<Individual, List<Individual>> childrenPointers;

    public static RegularPedigree getRegularPedigree(Pedigree p) {
        if (p instanceof RegularPedigree) {
            return (RegularPedigree)p;
        }
        HashSet<Individual> founders = new HashSet<Individual>();
        for (Individual i : p.individuals()) {
            Individual f = p.parent(i, 0);
            Individual m = p.parent(i, 1);
            if (f == null && m == null) {
                founders.add(i);
                continue;
            }
            if (f != null && m != null) continue;
            return null;
        }
        return new RegularPedigree(p, founders);
    }

    private RegularPedigree(Pedigree p, Set<Individual> founders) {
        this.p = new SimplePedigree(p);
        this.founders = founders;
        this._computeMarriages();
        this.leaves = this._computeLeaves();
    }

    private Set<Individual> _computeLeaves() {
        HashSet<Individual> result = new HashSet<Individual>();
        for (Individual i : this.individuals()) {
            if (!this.children(i).isEmpty()) continue;
            result.add(i);
        }
        return result;
    }

    private void _computeMarriages() {
        this.marriages = new HashMap<Pair<Individual, Individual>, List<Individual>>();
        this.childrenPointers = new HashMap<Individual, List<Individual>>();
        for (Individual child : this.individuals()) {
            if (this.founders.contains(child)) continue;
            Individual father = this.parent(child, 0);
            Individual mother = this.parent(child, 1);
            Pair<Individual, Individual> key = Pair.makePair(father, mother);
            CollUtils.getNoNullList(this.marriages, key).add(child);
            CollUtils.getNoNullList(this.childrenPointers, father).add(child);
            CollUtils.getNoNullList(this.childrenPointers, mother).add(child);
        }
    }

    public Collection<Pair<Individual, Individual>> marriages() {
        return this.marriages.keySet();
    }

    public List<Individual> children(Pair<Individual, Individual> marriage) {
        List<Individual> result = this.marriages.get(marriage);
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public List<Individual> children(Individual i) {
        List<Individual> result = this.childrenPointers.get(i);
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    @Override
    public Collection<Individual> individuals() {
        return this.p.individuals();
    }

    @Override
    public Individual parent(Individual i, int index) {
        return this.p.parent(i, index);
    }

    public Collection<Individual> founders() {
        return this.founders;
    }

    public Set<Individual> leaves() {
        return this.leaves;
    }

    public String toString() {
        return "RegularPedigree(nIndiv=" + this.individuals().size() + ",nFounders=" + this.founders().size() + ",nMarriages=" + this.marriages().size() + ",nLeaves=" + this.leaves().size() + ")";
    }
}

