/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import fig.basic.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import pepper.FeatureVector;
import pepper.SparseFeatureVector;

public class Language {
    private static final int K = 3;
    private String name;
    private FeatureVector ngramCounts;
    private int numWords;

    public int getNumWords() {
        return this.numWords;
    }

    public Language(String name) {
        this.name = name;
        this.ngramCounts = new SparseFeatureVector();
    }

    public boolean isGoodChar(char c) {
        return Character.isLetter(c);
    }

    private boolean isGoodWord(String word) {
        for (int i = 0; i < word.length(); ++i) {
            if (this.isGoodChar(word.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void addWordToken(String word) {
        if (!this.isGoodWord(word = word.toLowerCase())) {
            return;
        }
        word = "^" + word + "$";
        for (int i = 3; i <= word.length(); ++i) {
            this.ngramCounts.incrValue(word.substring(i - 3, i), 1.0);
        }
        ++this.numWords;
    }

    public FeatureVector getFeatureVector() {
        return this.ngramCounts;
    }

    public void readCache(String path) throws IOException {
        String line;
        BufferedReader in = IOUtils.openIn(path);
        while ((line = in.readLine()) != null) {
            if (line.charAt(0) == '#') continue;
            String[] tokens = line.split("\t");
            if (tokens.length != 2) {
                throw new RuntimeException("Bad line: " + line);
            }
            this.ngramCounts.setValue(tokens[0], Double.parseDouble(tokens[1]));
        }
        in.close();
    }

    public void writeCache(String path) throws IOException {
        PrintWriter out = IOUtils.openOut(path);
        out.println("# numWords = " + this.numWords);
        for (String key : this.ngramCounts) {
            out.println(key + "\t" + this.ngramCounts.getValue(key));
        }
        out.close();
    }

    public static Language createLanguage(FeatureVector fv) {
        Language language = new Language(null);
        language.ngramCounts = fv;
        return language;
    }

    public String toString() {
        return this.name + " (" + this.numWords + " words)";
    }
}

