/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import java.util.Arrays;
import java.util.Collection;

public class BayesRiskMinimizer {
    public String findBestWord(String[] words) {
        return this.findBestWord(Arrays.asList(words));
    }

    public String findBestWord(Collection<String> words) {
        String bestWord = null;
        int bestDist = Integer.MAX_VALUE;
        for (String word : words) {
            int dist = this.computeDist(word, words);
            if (dist >= bestDist) continue;
            bestDist = dist;
            bestWord = word;
        }
        return bestWord;
    }

    public int computeDist(String w1, Collection<String> words) {
        int sum = 0;
        for (String w2 : words) {
            sum = (int)((double)sum + BayesRiskMinimizer.computeDist(w1, w2));
        }
        return sum;
    }

    public static double computeDist(String w1, String w2) {
        if (w1 == null || w2 == null) {
            throw new RuntimeException("Null args: computeDist(" + w1 + "," + w2 + ")");
        }
        int n1 = w1.length();
        int n2 = w2.length();
        int[][] minDist = new int[n1 + 1][n2 + 1];
        for (int i = 0; i <= n1; ++i) {
            for (int j = 0; j <= n2; ++j) {
                minDist[i][j] = i == 0 || j == 0 ? i + j : (w1.charAt(i - 1) == w2.charAt(j - 1) ? minDist[i - 1][j - 1] : 1 + Math.min(minDist[i - 1][j], Math.min(minDist[i - 1][j - 1], minDist[i][j - 1])));
            }
        }
        return minDist[n1][n2];
    }

    public static void main(String[] args) {
        System.out.println("Dist:" + BayesRiskMinimizer.computeDist("kitten", "sitting"));
    }
}

