/*
 * Decompiled with CFR 0.152.
 */
package pty.io;

import fig.basic.Option;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import nuts.io.IO;
import nuts.math.Evaluator;
import pty.RootedTree;
import pty.UnrootedTree;

public class TreeEvaluator {
    public static List<Evaluator.EvaluationScorer<RootedTree>> treeEvaluationMetrics = Arrays.asList(new PartitionMetric(), new NormalizedPartitionMetric(), new TightlyNormalizedPartitionMetric(), new RobinsonFouldsMetric(), new KuhnerFelsenstein(), new NormalizedRobinsonFouldsMetric(), new NormalizedKuhnerFelsenstein());
    public static List<TreeMetric> coreTreeMetrics = Arrays.asList(new PartitionMetric(), new RobinsonFouldsMetric(), new KuhnerFelsenstein());

    public static void main(String[] args) {
        IO.run(args, new TreeEvaluatorMain());
    }

    public static class NormalizedKuhnerFelsenstein
    extends TreeMetric {
        @Override
        public double score(UnrootedTree ref, UnrootedTree guess) {
            return UnrootedTree.normalizedKuhnerFelsenstein(ref, guess);
        }

        public String toString() {
            return "NormalizedKuhnerFelsenstein";
        }
    }

    public static class NormalizedRobinsonFouldsMetric
    extends TreeMetric {
        @Override
        public double score(UnrootedTree ref, UnrootedTree guess) {
            return UnrootedTree.normalizedRobinsonFouldsMetric(ref, guess);
        }

        public String toString() {
            return "NormalizedRobinsonFouldsMetric";
        }
    }

    public static class KuhnerFelsenstein
    extends TreeMetric {
        @Override
        public double score(UnrootedTree ref, UnrootedTree guess) {
            return UnrootedTree.kuhnerFelsenstein(ref, guess);
        }

        public String toString() {
            return "KuhnerFelsenstein";
        }
    }

    public static class RobinsonFouldsMetric
    extends TreeMetric {
        @Override
        public double score(UnrootedTree ref, UnrootedTree guess) {
            return UnrootedTree.robinsonFouldsMetric(ref, guess);
        }

        public String toString() {
            return "RobinsonFouldsMetric";
        }
    }

    public static class TightlyNormalizedPartitionMetric
    extends TreeMetric {
        @Override
        public double score(UnrootedTree ref, UnrootedTree guess) {
            return UnrootedTree.tightlyNormalizedPartitionMetric(ref, guess);
        }

        public String toString() {
            return "TightlyNormalizedPartitionMetric";
        }
    }

    public static class NormalizedPartitionMetric
    extends TreeMetric {
        @Override
        public double score(UnrootedTree ref, UnrootedTree guess) {
            return UnrootedTree.normalizedPartitionMetric(ref, guess);
        }

        public String toString() {
            return "NormalizedPartitionMetric";
        }
    }

    public static class PartitionMetric
    extends TreeMetric {
        @Override
        public double score(UnrootedTree ref, UnrootedTree guess) {
            return UnrootedTree.partitionMetric(ref, guess);
        }

        public String toString() {
            return "PartitionMetric";
        }
    }

    public static abstract class TreeMetric
    implements Evaluator.EvaluationScorer<RootedTree> {
        @Override
        public double worstScore() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public double score(UnrootedTree ut1, UnrootedTree ut2) {
            throw new RuntimeException();
        }

        @Override
        public double score(RootedTree rt1, RootedTree rt2) {
            return this.score(UnrootedTree.fromRooted(rt1), UnrootedTree.fromRooted(rt2));
        }

        public boolean equals(Object obj) {
            return this.toString().equals(obj);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    public static class RootedTreeParser
    implements Evaluator.Parser<RootedTree> {
        @Override
        public RootedTree parse(File f) {
            return RootedTree.Util.load(f);
        }
    }

    public static class TreeEvaluatorMain
    implements Runnable {
        @Option(required=true)
        public File refDirectory;
        @Option(required=true)
        public File guessDirectory;
        @Option
        public String refSuffix = null;
        @Option
        public String guessSuffix = null;

        @Override
        public void run() {
            Evaluator.evaluate(this.refDirectory, this.refSuffix, this.guessDirectory, this.guessSuffix, new RootedTreeParser(), treeEvaluationMetrics);
        }
    }
}

