/*
 * Decompiled with CFR 0.152.
 */
package pty.learn;

import Jama.Matrix;
import nuts.math.RateMtxUtils;

public class Estimators {
    public static double[][] getGeneralRateMatrixMLE(Matrix suffStats) {
        return Estimators.getGeneralRateMatrixMLE(suffStats, Double.POSITIVE_INFINITY);
    }

    public static double[][] getGeneralRateMatrixMLE(Matrix suffStats, double maxValue) {
        int nChars = suffStats.getColumnDimension();
        double[][] result = new double[nChars][nChars];
        for (int a = 0; a < nChars; ++a) {
            for (int b = 0; b < nChars; ++b) {
                if (a == b) continue;
                result[a][b] = Math.min(maxValue, suffStats.get(a, b) / suffStats.get(a, a));
            }
        }
        RateMtxUtils.fillRateMatrixDiagonalEntries(result);
        return result;
    }
}

