/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.prob.SampleUtils;
import java.util.Random;

public class BrownianMotion {
    private double quantum = 0.001;
    private double t = 0.0;
    private double b_t = 0.0;
    private static double a = 5.0;
    private static double b = 3.0;
    private Random rand = new Random();
    private double cache = -1.0;

    private void nextT() {
        if (this.cache == -1.0) {
            this.cache = Math.sqrt(this.quantum);
        }
        this.b_t += this.cache * SampleUtils.sampleGaussian(this.rand);
        this.t += this.quantum;
    }

    public double sampleCov() {
        assert (a > 0.0 && b > 0.0);
        while (this.b_t < a && this.b_t > -b) {
            this.nextT();
        }
        return this.t * (this.b_t > 0.0 ? a : b);
    }

    public static void main(String[] args) {
        double sum = 0.0;
        double N2 = 1000.0;
        int i = 0;
        while ((double)i < N2) {
            BrownianMotion bm = new BrownianMotion();
            sum += bm.sampleCov();
            ++i;
        }
        System.out.println("(" + a + "," + b + ") -> " + sum / N2);
    }
}

