/*
 * Decompiled with CFR 0.152.
 */
package smc;

import conifer.apps.AbstractPhyloApp;
import conifer.apps.PhyloAppUtils;
import conifer.exp.Experiment;
import conifer.exp.TreeReconstructionExperiment;
import conifer.particle.PhyloParticle;
import ev.poi.processors.TreeDistancesProcessor;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Random;
import monaco.StandardKernel;
import monaco.process.ProcessSchedule;
import monaco.process.ProcessScheduleContext;
import nuts.util.Counter;
import smc.EntangledParticle;
import smc.EntangledRandom;
import smc.Timer;
import smc.WeightCommunication;

public class PhyloEntangledMCMCKernel
extends AbstractPhyloApp
implements Runnable {
    @Option(required=true)
    public int N;
    @Option(required=true)
    public int numMachines;
    @Option(required=true)
    public int machineId;
    @Option(required=true)
    public EntangledParticle.ParticleAllocationStyle allocationStyle;
    @Option(required=true)
    public Random rand1 = new Random(1L);
    @Option(required=true)
    public Random rand2 = new Random(1L);
    private TreeDistancesProcessor processor;
    private Timer timer = new Timer();
    private int T;
    private int burnIn;
    int numMonitored = 0;
    Counter<UnorderedPair<Taxon, Taxon>> totalDistances = null;

    @Override
    public void monitor(ProcessScheduleContext context) {
        ++this.numMonitored;
        this.timer.stopTimer();
        LogInfo.logs("generation=" + context.getGeneration());
        File file = new File(WeightCommunication.commDirPath + "/processor." + this.machineId + "." + context.getGeneration() + ".file");
        ObjectOutputStream oos = IOUtils.openBinOutEasy(file);
        try {
            oos.writeObject(this.processor);
            oos.close();
            file = new File(WeightCommunication.commDirPath + "/processor." + this.machineId + "." + context.getGeneration() + ".done.file");
            file.createNewFile();
            if (context.getGeneration() > this.burnIn) {
                this.unserialize(context.getGeneration());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            if (context.getGeneration() > this.burnIn) {
                this.unserialize(context.getGeneration());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.timer.resumeTimer();
    }

    private void unserialize(int t) throws IOException, ClassNotFoundException {
        List<Experiment> exps = this.getExperiments();
        TreeReconstructionExperiment exp = (TreeReconstructionExperiment)exps.get(0);
        Counter<UnorderedPair<Taxon, Taxon>> distances = null;
        File doneFile = null;
        for (int k = 0; k < this.numMachines; ++k) {
            doneFile = new File(WeightCommunication.commDirPath + "/processor." + k + "." + t + ".done.file");
            while (!doneFile.exists()) {
            }
            ObjectInputStream ois = IOUtils.openBinIn(new File(WeightCommunication.commDirPath + "/processor." + k + "." + t + ".file"));
            TreeDistancesProcessor tdp = (TreeDistancesProcessor)ois.readObject();
            Counter<UnorderedPair<Taxon, Taxon>> _meanDistances = tdp.getMeanDistances();
            if (distances == null) {
                distances = _meanDistances;
                continue;
            }
            distances.incrementAll(_meanDistances);
        }
        if (this.totalDistances == null) {
            this.totalDistances = distances;
        } else {
            double prevMax = this.totalDistances.max();
            this.totalDistances.incrementAll(distances);
            double currMax = this.totalDistances.max();
            if (prevMax >= currMax) {
                throw new RuntimeException();
            }
        }
        Object[] context2 = new Object[]{"generation", "cumulative" + t, "ticks", this.timer.getTicks()};
    }

    public static void main(String[] args) {
        PhyloAppUtils.run(args, new PhyloEntangledMCMCKernel());
    }

    @Override
    public void run() {
        this.timer.startTimer();
        LogInfo.logs("machine=" + this.machineId + " starting");
        this.burnIn = this.allOptions.processOptions.burnIn;
        int[][] config = new int[2][this.numMachines];
        int numParticlesPerMachine = this.N / this.numMachines;
        int sum = 0;
        for (int k = 0; k < this.numMachines; ++k) {
            config[0][k] = k == this.numMachines - 1 ? this.N - sum : numParticlesPerMachine;
            sum += config[0][k];
            config[1][k] = (int)Math.ceil((double)config[0][k] * 1.1);
        }
        LogInfo.logs("config=" + config[0][0]);
        LogInfo.logs("capacity=" + config[1][0]);
        StandardKernel<PhyloParticle> kernel = this.getKernel();
        this.T = kernel.nIterationsLeft((PhyloParticle)kernel.getInitial());
        LogInfo.logs("T=" + this.T);
        EntangledRandom eRandom = new EntangledRandom(this.machineId, this.N, this.T, this.rand1, this.rand2);
        this.processor = new TreeDistancesProcessor();
        ProcessSchedule schedule = this.allOptions.processOptions.getSchedule(this);
        EntangledParticle<PhyloParticle> entangled = EntangledParticle.run(kernel, this.processor, eRandom, this.machineId, config, this.N, this.allocationStyle, schedule);
        entangled.printStatistics();
        this.timer.stopTimer();
        LogInfo.logs("numMonitorCalled=" + this.numMonitored);
        LogInfo.logs("totalSeconds=" + this.timer.totalSeconds());
        LogInfo.logs("totalMinutes=" + this.timer.totalMinutes());
    }
}

