/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;
import spoon.compiler.SpoonResourceHelper;
import spoon.support.compiler.FileSystemFile;

public class FileSystemFolder
implements SpoonFolder {
    File file;

    public FileSystemFolder(File file) {
        if (!file.isDirectory()) {
            throw new SpoonException("Not a directory " + file);
        }
        this.file = file;
    }

    @Override
    public List<SpoonFile> getAllFiles() {
        ArrayList<SpoonFile> all = new ArrayList<SpoonFile>(this.getFiles());
        for (SpoonFolder f : this.getSubFolders()) {
            all.addAll(f.getAllFiles());
        }
        return all;
    }

    @Override
    public List<SpoonFile> getFiles() {
        ArrayList<SpoonFile> files = new ArrayList<SpoonFile>();
        for (File f : this.file.listFiles()) {
            if (!SpoonResourceHelper.isFile(f)) continue;
            files.add(new FileSystemFile(f));
        }
        return files;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public SpoonFolder getParent() {
        try {
            return SpoonResourceHelper.createFolder(this.file.getParentFile());
        }
        catch (FileNotFoundException e) {
            Launcher.logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<SpoonFolder> getSubFolders() {
        ArrayList<SpoonFolder> subFolders = new ArrayList<SpoonFolder>();
        for (File f : this.file.listFiles()) {
            if (SpoonResourceHelper.isArchive(f) || f.isFile()) continue;
            try {
                subFolders.add(SpoonResourceHelper.createFolder(f));
            }
            catch (FileNotFoundException e) {
                Launcher.logger.error(e.getMessage(), e);
            }
        }
        return subFolders;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public List<SpoonFile> getAllJavaFiles() {
        ArrayList<SpoonFile> files = new ArrayList<SpoonFile>();
        for (SpoonFile f : this.getFiles()) {
            if (!f.isJava()) continue;
            files.add(f);
        }
        for (SpoonFolder fol : this.getSubFolders()) {
            files.addAll(fol.getAllJavaFiles());
        }
        return files;
    }

    @Override
    public String getPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (Exception e) {
            Launcher.logger.error(e.getMessage(), e);
            return this.file.getPath();
        }
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public File getFileSystemParent() {
        return this.file.getParentFile();
    }

    @Override
    public File toFile() {
        try {
            return this.file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new SpoonException(e);
        }
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public void addFile(SpoonFile source) {
        throw new UnsupportedOperationException("not possible a real folder");
    }

    @Override
    public void addFolder(SpoonFolder source) {
        throw new UnsupportedOperationException("not possible a real folder");
    }
}

