/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.Query;
import spoon.support.reflect.code.CtStatementImpl;
import spoon.support.reflect.declaration.CtElementImpl;

public class CtBlockImpl<R>
extends CtStatementImpl
implements CtBlock<R> {
    private static final long serialVersionUID = 1L;
    private List<CtStatement> statements = CtBlockImpl.EMPTY_LIST();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtBlock(this);
    }

    @Override
    public List<CtStatement> getStatements() {
        if (this.statements == CtElementImpl.EMPTY_LIST()) {
            this.statements = new ArrayList<CtStatement>();
        }
        return this.statements;
    }

    public CtStatementList toStatementList() {
        return this.getFactory().Code().createStatementList(this);
    }

    @Override
    public <T extends CtStatement> T getStatement(int i) {
        return (T)this.statements.get(i);
    }

    @Override
    public <T extends CtStatement> T getLastStatement() {
        return (T)this.statements.get(this.statements.size() - 1);
    }

    @Override
    public void insertBegin(CtStatementList statements) {
        CtStatement first;
        if (this.getParentNoExceptions() != null && this.getParentNoExceptions() instanceof CtConstructor && this.getStatements().size() > 0 && (first = this.getStatements().get(0)) instanceof CtInvocation && ((CtInvocation)first).getExecutable().getSimpleName().startsWith("<init>")) {
            first.insertAfter(statements);
            return;
        }
        if (this.statements == CtElementImpl.EMPTY_LIST()) {
            this.statements = new ArrayList<CtStatement>();
        }
        this.statements.addAll(0, statements.getStatements());
    }

    @Override
    public void insertBegin(CtStatement statement) {
        CtStatement first;
        if (this.getParentNoExceptions() != null && this.getParentNoExceptions() instanceof CtConstructor && this.getStatements().size() > 0 && (first = this.getStatements().get(0)) instanceof CtInvocation && ((CtInvocation)first).getExecutable().getSimpleName().startsWith("<init>")) {
            first.insertAfter(statement);
            return;
        }
        if (this.statements == CtElementImpl.EMPTY_LIST()) {
            this.statements = new ArrayList<CtStatement>();
        }
        this.statements.add(0, statement);
    }

    @Override
    public void insertEnd(CtStatement statement) {
        if (this.statements == CtElementImpl.EMPTY_LIST()) {
            this.statements = new ArrayList<CtStatement>();
        }
        this.addStatement(statement);
    }

    @Override
    public void insertEnd(CtStatementList statements) {
        for (CtStatement s : statements.getStatements()) {
            this.insertEnd(s);
        }
    }

    @Override
    public void insertAfter(Filter<? extends CtStatement> insertionPoints, CtStatement statement) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertAfter(statement);
        }
    }

    @Override
    public void insertAfter(Filter<? extends CtStatement> insertionPoints, CtStatementList statements) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertAfter(statements);
        }
    }

    @Override
    public void insertBefore(Filter<? extends CtStatement> insertionPoints, CtStatement statement) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertBefore(statement);
        }
    }

    @Override
    public void insertBefore(Filter<? extends CtStatement> insertionPoints, CtStatementList statements) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertBefore(statements);
        }
    }

    @Override
    public void setStatements(List<CtStatement> statements) {
        this.statements = statements;
    }

    @Override
    public R S() {
        return null;
    }

    public void R(R value) {
    }

    public CtCodeElement getSubstitution(CtType<?> targetType) {
        return this.getFactory().Core().clone(this);
    }

    @Override
    public void addStatement(CtStatement statement) {
        if (this.statements == CtElementImpl.EMPTY_LIST()) {
            this.statements = new ArrayList<CtStatement>();
        }
        this.statements.add(statement);
    }

    @Override
    public void removeStatement(CtStatement statement) {
        if (this.statements == CtElementImpl.EMPTY_LIST()) {
            this.statements = new ArrayList<CtStatement>();
        }
        this.statements.remove(statement);
    }

    @Override
    public Iterator<CtStatement> iterator() {
        return Collections.unmodifiableList(new ArrayList<CtStatement>(this.getStatements())).iterator();
    }
}

