/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.support.reflect.code.CtCodeElementImpl;

public abstract class CtStatementImpl
extends CtCodeElementImpl
implements CtStatement {
    private static final long serialVersionUID = 1L;
    String label;

    public static void insertAfter(CtStatement target, CtStatement statement) throws ParentNotInitializedException {
        CtStatementList sts = target.getFactory().Core().createStatementList();
        sts.addStatement(statement);
        CtStatementImpl.insertAfter(target, sts);
    }

    public static void replace(CtStatement target, CtStatementList statements) throws ParentNotInitializedException {
        CtStatementImpl.insertAfter(target, statements);
        CtElement e = target.getParent();
        CtStatementList parentStatementList = (CtStatementList)e;
        parentStatementList.removeStatement(target);
    }

    public static void insertAfter(CtStatement target, CtStatementList statements) throws ParentNotInitializedException {
        CtElement e = target.getParent();
        if (e instanceof CtExecutable) {
            throw new RuntimeException("cannot insert in this context (use insertEnd?)");
        }
        CtStatementList parentStatementList = (CtStatementList)e;
        int i = 0;
        for (CtStatement s : parentStatementList.getStatements()) {
            ++i;
            if (s != target) continue;
            break;
        }
        for (int j = statements.getStatements().size() - 1; j >= 0; --j) {
            CtStatement s;
            s = statements.getStatements().get(j);
            parentStatementList.getStatements().add(i, s);
        }
    }

    public static void insertBefore(CtStatement target, CtStatement statement) throws ParentNotInitializedException {
        CtStatementList sts = target.getFactory().Core().createStatementList();
        sts.addStatement(statement);
        CtStatementImpl.insertBefore(target, sts);
    }

    public static void insertBefore(CtStatement target, CtStatementList statementsToBeInserted) throws ParentNotInitializedException {
        CtBlock parentBlock;
        CtElement targetParent = target.getParent();
        if (targetParent instanceof CtExecutable) {
            throw new RuntimeException("cannot insert in this context (use insertEnd?)");
        }
        if (targetParent instanceof CtIf) {
            boolean inThen = true;
            Object stat = ((CtIf)targetParent).getThenStatement();
            if (stat != target) {
                stat = ((CtIf)targetParent).getElseStatement();
                inThen = false;
            }
            if (stat != target) {
                throw new IllegalArgumentException("should not happen");
            }
            if (stat instanceof CtBlock) {
                ((CtBlock)stat).insertBegin(statementsToBeInserted);
                return;
            }
            CtBlock block = target.getFactory().Core().createBlock();
            target.setParent(block);
            block.addStatement((CtStatement)stat);
            if (inThen) {
                ((CtIf)targetParent).setThenStatement(block);
            } else {
                ((CtIf)targetParent).setElseStatement(block);
            }
            parentBlock = block;
        } else {
            if (targetParent instanceof CtSwitch) {
                CtStatement s;
                Object s22;
                for (Object s22 : statementsToBeInserted) {
                    if (s22 instanceof CtCase) continue;
                    throw new RuntimeException("cannot insert something that is not case in a switch");
                }
                int i = 0;
                s22 = ((CtSwitch)targetParent).getCases().iterator();
                while (s22.hasNext() && (s = (CtStatement)s22.next()) != target) {
                    ++i;
                }
                for (int j = statementsToBeInserted.getStatements().size() - 1; j >= 0; --j) {
                    s = statementsToBeInserted.getStatements().get(j);
                    ((CtSwitch)targetParent).getCases().add(i, (CtCase)s);
                }
                return;
            }
            if (targetParent instanceof CtLoop) {
                CtStatement stat = ((CtLoop)targetParent).getBody();
                if (stat instanceof CtBlock) {
                    CtBlock parentBlock2 = (CtBlock)stat;
                    ((CtBlock)stat).insertBegin(statementsToBeInserted);
                    return;
                }
                CtBlock block = target.getFactory().Core().createBlock();
                block.getStatements().add(stat);
                ((CtLoop)targetParent).setBody(block);
                parentBlock = block;
            } else {
                if (targetParent instanceof CtCase) {
                    int i = 0;
                    for (CtStatement s : ((CtCase)targetParent).getStatements()) {
                        if (s == target) break;
                        ++i;
                    }
                    for (int j = statementsToBeInserted.getStatements().size() - 1; j >= 0; --j) {
                        CtStatement s;
                        s = statementsToBeInserted.getStatements().get(j);
                        ((CtCase)targetParent).getStatements().add(i, s);
                    }
                    return;
                }
                parentBlock = (CtBlock)targetParent;
            }
        }
        if (!(parentBlock instanceof CtBlock)) {
            throw new RuntimeException("cannot add a statement that is not in a block");
        }
        int indexOfTargetElement = 0;
        for (CtStatement s : parentBlock.getStatements()) {
            if (s == target) break;
            ++indexOfTargetElement;
        }
        for (CtStatement s : statementsToBeInserted) {
            parentBlock.getStatements().add(indexOfTargetElement++, s);
        }
    }

    @Override
    public void insertBefore(CtStatement statement) throws ParentNotInitializedException {
        CtStatementImpl.insertBefore((CtStatement)this, statement);
    }

    @Override
    public void insertBefore(CtStatementList statements) throws ParentNotInitializedException {
        CtStatementImpl.insertBefore((CtStatement)this, statements);
    }

    @Override
    public void insertAfter(CtStatement statement) throws ParentNotInitializedException {
        CtStatementImpl.insertAfter((CtStatement)this, statement);
    }

    @Override
    public void insertAfter(CtStatementList statements) throws ParentNotInitializedException {
        CtStatementImpl.insertAfter((CtStatement)this, statements);
    }

    @Override
    public void replace(CtElement element) {
        if (element instanceof CtStatementList) {
            CtStatementImpl.replace(this, (CtStatementList)element);
        } else {
            super.replace(element);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }
}

