/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.log4j.Logger;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedAccess;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtUnboundVariableReference;
import spoon.reflect.visitor.CtVisitor;

public class SignaturePrinter
implements CtVisitor {
    private static final Logger logger = Logger.getLogger(SignaturePrinter.class);
    StringBuffer signature;

    public SignaturePrinter() {
        this.reset();
    }

    public String getSignature() {
        return this.signature.toString();
    }

    public void reset() {
        this.signature = new StringBuffer();
    }

    public void scan(CtElement e) {
        if (e != null) {
            e.accept(this);
        }
    }

    public void scan(CtReference e) {
        if (e != null) {
            e.accept(this);
        }
    }

    protected SignaturePrinter write(String value) {
        this.signature.append(value);
        return this;
    }

    private SignaturePrinter clearLast() {
        this.signature.deleteCharAt(this.signature.length() - 1);
        return this;
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        this.write("@");
        if (annotation.getAnnotationType() != null) {
            this.write(annotation.getAnnotationType().getQualifiedName());
        } else {
            logger.error("null annotation type at " + annotation.getPosition(), new Exception());
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.write("@interface ");
        this.write(annotationType.getQualifiedName());
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable e) {
        this.scan(e.getBody());
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        this.scan((CtElement)arrayAccess.getTarget());
        this.write("[");
        this.scan(arrayAccess.getIndexExpression());
        this.write("]");
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        this.scan(reference.getComponentType());
        this.write("[]");
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.signature.append("assert ");
        this.scan(asserted.getAssertExpression());
        this.signature.append(":");
        this.scan(asserted.getExpression());
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        for (CtTypeReference<?> ref : assignement.getTypeCasts()) {
            this.write("(");
            this.scan(ref);
            this.write(")");
        }
        this.write("(");
        this.scan(assignement.getAssigned());
        this.write(" = ");
        this.scan(assignement.getAssignment());
        this.write(")");
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        this.scan(operator.getLeftHandOperand());
        this.write(operator.getKind().toString());
        this.scan(operator.getRightHandOperand());
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        this.signature.append("{\n");
        for (CtStatement s : block.getStatements()) {
            this.scan(s);
            this.signature.append(";\n");
        }
        this.signature.append("}");
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.write("break ");
        if (breakStatement.getTargetLabel() != null) {
            this.write(breakStatement.getTargetLabel());
        }
    }

    public <E> void visitCtCase(CtCase<E> caseStatement) {
        this.write("case (");
        this.scan(caseStatement.getCaseExpression());
        this.write(")");
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.write("catch (");
        this.scan(catchBlock.getParameter().getType());
        this.write(")");
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.write("class ").write(ctClass.getQualifiedName());
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.scan(conditional.getCondition());
        this.write("?");
        this.scan(conditional.getThenExpression());
        this.write(":");
        this.scan(conditional.getElseExpression());
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        this.write(c.getDeclaringType().getQualifiedName());
        this.write("(");
        for (CtParameter<?> p : c.getParameters()) {
            this.scan(p.getType());
            this.write(",");
        }
        if (!c.getParameters().isEmpty()) {
            this.clearLast();
        }
        this.write(")");
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.signature.append("continue ");
        this.scan(continueStatement.getLabelledStatement());
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.write("do ");
        this.scan(doLoop.getBody());
        this.write(" while (");
        this.scan(doLoop.getLoopingExpression());
        this.write(")");
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.write("enum ").write(ctEnum.getQualifiedName());
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        if (reference.getDeclaringType() != null) {
            this.write(reference.getDeclaringType().getQualifiedName());
        }
        this.write("#");
        this.write(reference.getSimpleName());
        this.write("(");
        for (CtTypeReference<?> ref : reference.getActualTypeArguments()) {
            this.scan(ref);
            this.write(",");
        }
        if (!reference.getActualTypeArguments().isEmpty()) {
            this.clearLast();
        }
        this.write(")");
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        this.scan(f.getType());
        this.write(" ").write(f.getSimpleName());
    }

    public <T> void visitCtTargetedAccess(CtTargetedAccess<T> targetedAccess) {
        this.scan(targetedAccess.getVariable());
    }

    @Override
    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
        this.write(thisAccess.getType().getQualifiedName() + ".this");
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        this.scan((CtElement)annotationFieldAccess.getTarget());
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        if (reference.getType() != null) {
            this.write(reference.getType().getQualifiedName());
        } else {
            this.write("<no type>");
        }
        this.write(" ");
        this.write(reference.getDeclaringType().getQualifiedName());
        this.write("#");
        this.write(reference.getSimpleName());
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        this.write("for (");
        for (CtStatement s : forLoop.getForInit()) {
            this.scan(s);
            this.write(",");
        }
        if (!forLoop.getForInit().isEmpty()) {
            this.clearLast();
        }
        this.write(";");
        this.scan(forLoop.getExpression());
        this.write(";");
        for (CtStatement s : forLoop.getForUpdate()) {
            this.scan(s);
            this.write(",");
        }
        if (!forLoop.getForUpdate().isEmpty()) {
            this.clearLast();
        }
        this.write(")");
        this.scan(forLoop.getBody());
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.write("for (");
        this.scan(foreach.getVariable());
        this.write(":");
        this.scan(foreach.getExpression());
        this.write(")");
        this.scan(foreach.getBody());
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        this.write("if (");
        this.scan(ifElement.getCondition());
        this.write(") then ");
        this.scan((CtElement)ifElement.getThenStatement());
        this.write(" else\u00a0");
        this.scan((CtElement)ifElement.getElseStatement());
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.write("interface ");
        this.write(intrface.getQualifiedName());
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.write("(");
        this.scan(invocation.getExecutable());
        this.write("(");
        for (int i = 0; i < invocation.getArguments().size(); ++i) {
            CtExpression<?> arg_i = invocation.getArguments().get(i);
            this.scan(arg_i);
            if (i == invocation.getArguments().size() - 1) continue;
            this.write(",");
        }
        this.write(")");
        this.write(")");
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        if (literal.getValue() != null) {
            this.write(literal.toString());
        } else {
            this.write("null");
        }
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.write(localVariable.getSimpleName());
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        this.write(reference.getType().getQualifiedName()).write(" ");
        this.write(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        this.write(catchVariable.getSimpleName());
    }

    @Override
    public <T> void visitCtCatchVariableReference(CtCatchVariableReference<T> reference) {
        this.scan(reference.getDeclaration());
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        if (!m.getFormalTypeParameters().isEmpty()) {
            this.scan(m.getFormalTypeParameters());
            this.write(" ");
        }
        this.scan(m.getType());
        this.write(" ");
        this.write(m.getSimpleName());
        this.write("(");
        for (CtParameter<?> p : m.getParameters()) {
            this.scan(p.getType());
            this.write(",");
        }
        if (!m.getParameters().isEmpty()) {
            this.clearLast();
        }
        this.write(")");
    }

    public void scan(List<CtTypeReference<?>> formalTypeParameters) {
        if (formalTypeParameters != null && formalTypeParameters.size() > 0) {
            this.write("<");
            for (CtTypeReference<?> type : formalTypeParameters) {
                CtTypeParameterReference tmp;
                this.write(type.getQualifiedName());
                if (type instanceof CtTypeParameterReference && (tmp = (CtTypeParameterReference)type).getBounds() != null && tmp.getBounds().size() > 0) {
                    this.write(" extends ");
                    for (CtTypeReference<?> tmp2 : tmp.getBounds()) {
                        this.write(tmp2.getQualifiedName());
                    }
                    this.clearLast();
                }
                this.write(",");
            }
            this.clearLast();
            this.write(">");
        }
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        this.write("new ");
        this.scan(newArray.getType());
        for (CtExpression<Integer> ctExpression : newArray.getDimensionExpressions()) {
            this.write("[");
            this.scan(ctExpression);
            this.write("]");
        }
        this.write("{");
        for (CtExpression<Integer> ctExpression : newArray.getElements()) {
            this.scan(ctExpression);
            this.write(",");
        }
        if (!newArray.getElements().isEmpty()) {
            this.clearLast();
        }
        this.write("}");
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.write("new ");
        this.scan(ctConstructorCall.getExecutable());
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.write("new ");
        this.scan(newClass.getExecutable());
        this.scan(newClass.getAnonymousClass());
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        this.write("(");
        this.scan(lambda.getType());
        this.write(") (");
        if (!lambda.getParameters().isEmpty()) {
            for (CtParameter<?> parameter : lambda.getParameters()) {
                this.scan(parameter);
                this.write(",");
            }
            this.clearLast();
        }
        this.write(")");
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        this.write(expression.toString());
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
        this.write(expression.getValue());
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
        this.write(statement.getValue());
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        this.scan(assignment.getAssigned());
        this.write(assignment.getKind().toString());
        this.scan(assignment.getAssignment());
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        this.write(ctPackage.getQualifiedName());
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        this.write(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        this.write(parameter.getSimpleName());
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        this.write(reference.getType().getQualifiedName()).write(" ");
        this.write(reference.getSimpleName());
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.write("return ");
        this.scan(returnStatement.getReturnedExpression());
    }

    @Override
    public <R> void visitCtStatementList(CtStatementList statements) {
        for (CtStatement s : statements.getStatements()) {
            this.scan(s);
            this.write(";\n");
        }
    }

    public <E> void visitCtSwitch(CtSwitch<E> switchStatement) {
        this.write("switch(");
        this.scan(switchStatement.getSelector());
        this.write(")");
        for (CtCase<E> c : switchStatement.getCases()) {
            this.scan(c);
        }
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        this.write("synchronized (");
        this.scan(synchro.getExpression());
        this.write(") ");
        this.scan(synchro.getBlock());
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        this.write("throw ");
        this.scan(throwStatement.getThrownExpression());
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        this.write("try {\n");
        this.scan(tryBlock.getBody());
        for (CtCatch c : tryBlock.getCatchers()) {
            this.scan(c);
        }
        this.scan(tryBlock.getFinalizer());
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        this.write("try (");
        for (CtLocalVariable<?> resource : tryWithResource.getResources()) {
            this.scan(resource);
        }
        this.write(") {\n");
        this.scan(tryWithResource.getBody());
        for (CtCatch c : tryWithResource.getCatchers()) {
            this.scan(c);
        }
        this.scan(tryWithResource.getFinalizer());
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        this.write("<");
        this.write(typeParameter.getName());
        this.write(">");
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        this.write(ref.getQualifiedName());
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        this.write(reference.getQualifiedName());
    }

    @Override
    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
        this.scan(typeAccess.getType());
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.scan(operator.getOperand());
        this.write(operator.getKind().toString());
    }

    @Override
    public <T> void visitCtVariableAccess(CtVariableAccess<T> variableAccess) {
        this.scan(variableAccess.getVariable());
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.write("while (");
        this.scan(whileLoop.getLoopingExpression());
        this.write(")");
        this.scan(whileLoop.getBody());
    }

    @Override
    public <T> void visitCtUnboundVariableReference(CtUnboundVariableReference<T> reference) {
        this.write(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtFieldAccess(CtFieldAccess<T> f) {
        this.scan(f.getVariable());
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.scan(f.getVariable());
    }
}

