/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public final class support_transfer {
    public static void main(String[] stringArray) {
        Phylogeny phylogeny = null;
        Phylogeny phylogeny2 = null;
        File file = null;
        File file2 = null;
        File file3 = null;
        int n = 0;
        if (stringArray.length != 3 && stringArray.length != 4) {
            System.err.println("SupportTransfer: Wrong number of arguments. Usage: \"java transfersBranchLenghts <treefile with correct b.l.> <treefile with bootstraps><outputfile> [number of tree with correct bl to use in case treefile contains more than one, default 0]\"");
            System.exit(-1);
        }
        if (stringArray.length == 4) {
            n = new Integer(stringArray[3]);
        }
        try {
            file = new File(stringArray[0]);
            file2 = new File(stringArray[1]);
            file3 = new File(stringArray[2]);
            if (file3.exists()) {
                System.out.println("transfersBranchLenghts: " + file3.getAbsolutePath() + " does already exist.");
                System.exit(-1);
            }
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            PhylogenyParser phylogenyParser2 = ParserUtils.createParserDependingOnFileType(file2, true);
            if (phylogenyParser instanceof NHXParser) {
                ((NHXParser)phylogenyParser).setTaxonomyExtraction(PhylogenyMethods.TAXONOMY_EXTRACTION.YES);
            }
            phylogeny = phylogenyFactory.create(file, phylogenyParser)[n];
            phylogeny2 = phylogenyFactory.create(file2, phylogenyParser2)[0];
        }
        catch (IOException iOException) {
            System.out.println("SupportTransfer: Could not read tree(s): " + iOException);
            System.exit(-1);
        }
        try {
            double d = PhylogenyMethods.getMaximumConfidenceValue(phylogeny2);
            PhylogenyMethods.normalizeBootstrapValues(phylogeny2, d, 100.0);
            support_transfer.transferSupportValues(phylogeny2, phylogeny);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException.getMessage());
            System.exit(-1);
        }
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(file3, phylogeny, 0);
        }
        catch (IOException iOException) {
            System.out.println("Failure to write phylogeny '" + file3 + "\" [" + iOException.getMessage() + "]");
            System.exit(-1);
        }
    }

    public static final void moveBranchLengthsToBootstrap(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isInternal() && phylogenyNode.getDistanceToParent() > 0.0) {
                PhylogenyMethods.setBootstrapConfidence(phylogenyNode, phylogenyNode.getDistanceToParent());
            } else {
                PhylogenyMethods.setBootstrapConfidence(phylogenyNode, -9999.0);
            }
            phylogenyNode.setDistanceToParent(-1024.0);
        }
    }

    public static final void transferSupportValues(Phylogeny phylogeny, Phylogeny phylogeny2) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny2.iteratorPostorder();
        block0: while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal()) continue;
            List<String> list = phylogenyNode.getAllExternalDescendantsNames();
            PhylogenyNodeIterator phylogenyNodeIterator2 = phylogeny.iteratorPostorder();
            while (phylogenyNodeIterator2.hasNext()) {
                PhylogenyNode phylogenyNode2 = phylogenyNodeIterator2.next();
                List<String> list2 = phylogenyNode2.getAllExternalDescendantsNames();
                if (list2.size() != list.size() || !list2.containsAll(list)) continue;
                PhylogenyMethods.setBootstrapConfidence(phylogenyNode, PhylogenyMethods.getConfidenceValue(phylogenyNode2));
                continue block0;
            }
            throw new IllegalArgumentException("Attempt to transfer support values from nonidentical topologies");
        }
    }
}

