/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.distance;

import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.msa.Msa;

public final class PairwiseDistanceCalculator {
    public static final double DEFAULT_VALUE_FOR_TOO_LARGE_DISTANCE_FOR_KIMURA_FORMULA = 10.0;
    private static final char GAP = '-';
    private final Msa _msa;
    private final double _value_for_too_large_distance_for_kimura_formula;

    private PairwiseDistanceCalculator(Msa msa, double d) {
        this._msa = msa;
        this._value_for_too_large_distance_for_kimura_formula = d;
    }

    private double calcFractionalDissimilarity(int n, int n2) {
        int n3 = this._msa.getLength();
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            char c = this._msa.getResidueAt(n, i);
            char c2 = this._msa.getResidueAt(n2, i);
            if (c == '-' || c2 == '-') continue;
            if (c != c2) {
                ++n4;
            }
            ++n5;
        }
        if (n5 == 0) {
            return 1.0;
        }
        return (double)n4 / (double)n5;
    }

    private double calcKimuraDistance(int n, int n2) {
        double d = this.calcFractionalDissimilarity(n, n2);
        double d2 = 1.0 - d - 0.2 * d * d;
        if (d2 <= 0.0) {
            return this._value_for_too_large_distance_for_kimura_formula;
        }
        if (d2 == 1.0) {
            return 0.0;
        }
        return -Math.log(d2);
    }

    private double calcPoissonDistance(int n, int n2) {
        double d = this.calcFractionalDissimilarity(n, n2);
        double d2 = 1.0 - d;
        if (d2 <= 0.0) {
            return this._value_for_too_large_distance_for_kimura_formula;
        }
        if (d2 == 1.0) {
            return 0.0;
        }
        return -Math.log(d2);
    }

    private BasicSymmetricalDistanceMatrix calcKimuraDistances() {
        int n = this._msa.getNumberOfSequences();
        BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = new BasicSymmetricalDistanceMatrix(n);
        this.copyIdentifiers(n, basicSymmetricalDistanceMatrix);
        this.calcKimuraDistances(n, basicSymmetricalDistanceMatrix);
        return basicSymmetricalDistanceMatrix;
    }

    private BasicSymmetricalDistanceMatrix calcPoissonDistances() {
        int n = this._msa.getNumberOfSequences();
        BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = new BasicSymmetricalDistanceMatrix(n);
        this.copyIdentifiers(n, basicSymmetricalDistanceMatrix);
        this.calcPoissonDistances(n, basicSymmetricalDistanceMatrix);
        return basicSymmetricalDistanceMatrix;
    }

    private BasicSymmetricalDistanceMatrix calcFractionalDissimilarities() {
        int n = this._msa.getNumberOfSequences();
        BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = new BasicSymmetricalDistanceMatrix(n);
        this.copyIdentifiers(n, basicSymmetricalDistanceMatrix);
        this.calcFractionalDissimilarities(n, basicSymmetricalDistanceMatrix);
        return basicSymmetricalDistanceMatrix;
    }

    private void calcKimuraDistances(int n, BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                basicSymmetricalDistanceMatrix.setValue(i, j, this.calcKimuraDistance(i, j));
            }
        }
    }

    private void calcPoissonDistances(int n, BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                basicSymmetricalDistanceMatrix.setValue(i, j, this.calcPoissonDistance(i, j));
            }
        }
    }

    private void calcFractionalDissimilarities(int n, BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                basicSymmetricalDistanceMatrix.setValue(i, j, this.calcFractionalDissimilarity(i, j));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private void copyIdentifiers(int n, BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        for (int i = 0; i < n; ++i) {
            basicSymmetricalDistanceMatrix.setIdentifier(i, (String)this._msa.getIdentifier(i));
        }
    }

    public static BasicSymmetricalDistanceMatrix calcFractionalDissimilarities(Msa msa) {
        return new PairwiseDistanceCalculator(msa, 10.0).calcFractionalDissimilarities();
    }

    public static BasicSymmetricalDistanceMatrix calcPoissonDistances(Msa msa) {
        return new PairwiseDistanceCalculator(msa, 10.0).calcPoissonDistances();
    }

    public static BasicSymmetricalDistanceMatrix calcKimuraDistances(Msa msa) {
        return new PairwiseDistanceCalculator(msa, 10.0).calcKimuraDistances();
    }

    public static BasicSymmetricalDistanceMatrix calcKimuraDistances(Msa msa, double d) {
        return new PairwiseDistanceCalculator(msa, d).calcKimuraDistances();
    }

    public static enum PWD_DISTANCE_METHOD {
        KIMURA_DISTANCE,
        POISSON_DISTANCE,
        FRACTIONAL_DISSIMILARITY;

    }
}

