/*
 * Decompiled with CFR 0.152.
 */
package com.cflex.util.lpSolve;

import com.cflex.util.lpSolve.DoubleReference;
import com.cflex.util.lpSolve.LpConstant;
import com.cflex.util.lpSolve.LpModel;
import com.cflex.util.lpSolve.Solver;
import java.util.Arrays;
import java.util.Random;

public class LpSolver
extends Solver
implements LpConstant {
    int JustInverted;
    int Status;
    int DoIter;
    int DoInvert;
    int Break_bb;
    double Extrad;
    double Trej;
    int Level;

    public LpSolver(LpModel lpModel) {
        super(lpModel);
    }

    final double myRound(double d, double d2) throws Exception {
        return Math.abs(d) < d2 ? 0.0 : d;
    }

    private void addEtaColumn(LpModel lpModel) throws Exception {
        double d;
        int n = lpModel.etaColEnd[lpModel.etaSize];
        ++lpModel.etaSize;
        int n2 = lpModel.etaColEnd[lpModel.etaSize] - 1;
        lpModel.etaValue[n2] = d = 1.0 / lpModel.etaValue[n2];
        int n3 = n;
        while (n3 < n2) {
            int n4 = n3++;
            lpModel.etaValue[n4] = lpModel.etaValue[n4] * -d;
        }
        this.JustInverted = 0;
    }

    public void setPivotColumn(LpModel lpModel, int n, int n2, double[] dArray) throws Exception {
        int n3 = 0;
        while (n3 <= lpModel.rows) {
            dArray[n3] = 0.0;
            ++n3;
        }
        if (n != 0) {
            if (n2 > lpModel.rows) {
                int n4 = n2 - lpModel.rows;
                n3 = lpModel.colEnd[n4 - 1];
                while (n3 < lpModel.colEnd[n4]) {
                    dArray[lpModel.mat[n3].rowNr] = lpModel.mat[n3].value;
                    ++n3;
                }
                dArray[0] = dArray[0] - this.Extrad;
            } else {
                dArray[n2] = 1.0;
            }
        } else if (n2 > lpModel.rows) {
            int n5 = n2 - lpModel.rows;
            n3 = lpModel.colEnd[n5 - 1];
            while (n3 < lpModel.colEnd[n5]) {
                dArray[lpModel.mat[n3].rowNr] = -lpModel.mat[n3].value;
                ++n3;
            }
            dArray[0] = dArray[0] + this.Extrad;
        } else {
            dArray[n2] = -1.0;
        }
        lpModel.ftran(dArray);
    }

    private void minorIteration(LpModel lpModel, int n, int n2) throws Exception {
        double d;
        int n3;
        double d2 = 0.0;
        int n4 = n + lpModel.rows;
        int n5 = n3 = lpModel.etaColEnd[lpModel.etaSize];
        ++lpModel.etaSize;
        if (this.Extrad != 0.0) {
            lpModel.etaRowNr[n3] = 0;
            lpModel.etaValue[n3] = -this.Extrad;
            if (++n3 >= lpModel.etaAlloc) {
                lpModel.resizeEta(n3);
            }
        }
        int n6 = lpModel.colEnd[n - 1];
        while (n6 < lpModel.colEnd[n]) {
            int n7 = lpModel.mat[n6].rowNr;
            if (n7 == 0 && this.Extrad != 0.0) {
                int n8 = lpModel.etaColEnd[lpModel.etaSize - 1];
                lpModel.etaValue[n8] = lpModel.etaValue[n8] + lpModel.mat[n6].value;
            } else if (n7 != n2) {
                lpModel.etaRowNr[n3] = n7;
                lpModel.etaValue[n3] = lpModel.mat[n6].value;
                if (++n3 >= lpModel.etaAlloc) {
                    lpModel.resizeEta(n3);
                }
            } else {
                d2 = lpModel.mat[n6].value;
            }
            ++n6;
        }
        lpModel.etaRowNr[n3] = n2;
        lpModel.etaValue[n3] = 1.0 / d2;
        lpModel.rhs[n2] = d = lpModel.rhs[n2] / d2;
        int n9 = n5;
        while (n9 < n3) {
            int n10 = lpModel.etaRowNr[n9];
            lpModel.rhs[n10] = lpModel.rhs[n10] - d * lpModel.etaValue[n9];
            ++n9;
        }
        int n11 = lpModel.bas[n2];
        lpModel.bas[n2] = n4;
        lpModel.basis[n11] = 0;
        lpModel.basis[n4] = 1;
        n9 = n5;
        while (n9 < n3) {
            int n12 = n9++;
            lpModel.etaValue[n12] = lpModel.etaValue[n12] / -d2;
        }
        lpModel.etaColEnd[lpModel.etaSize] = n3 + 1;
    }

    private void rhsMinColumn(LpModel lpModel, double d, int n, int n2) throws Exception {
        if (n > lpModel.rows + 1) {
            throw new Exception("Error: rhsmincol called with rowNr: " + n + ", rows: " + lpModel.rows + "." + "This indicates numerical instability\n");
        }
        int n3 = lpModel.etaColEnd[lpModel.etaSize];
        int n4 = lpModel.etaColEnd[lpModel.etaSize + 1];
        int n5 = n3;
        while (n5 < n4) {
            double d2 = lpModel.rhs[lpModel.etaRowNr[n5]] - d * lpModel.etaValue[n5];
            lpModel.rhs[lpModel.etaRowNr[n5]] = d2 = this.myRound(d2, lpModel.epsb);
            ++n5;
        }
        lpModel.rhs[n] = d;
        int n6 = lpModel.bas[n];
        lpModel.bas[n] = n2;
        lpModel.basis[n6] = 0;
        lpModel.basis[n2] = 1;
    }

    void getReducedCosts(LpModel lpModel, double[] dArray) throws Exception {
        if (lpModel.basisValid == 0) {
            throw new Exception("Not a valid basis in get_reduced_costs");
        }
        if (lpModel.etaValid == 0) {
            this.invert(lpModel);
        }
        int n = 1;
        while (n <= lpModel.sum) {
            dArray[n] = 0.0;
            ++n;
        }
        dArray[0] = 1.0;
        lpModel.btran(dArray);
        n = 1;
        while (n <= lpModel.columns) {
            int n2 = lpModel.rows + n;
            if (lpModel.basis[n2] == 0 && lpModel.upperBound[n2] > 0.0) {
                double d = 0.0;
                int n3 = lpModel.colEnd[n - 1];
                while (n3 < lpModel.colEnd[n]) {
                    d += dArray[lpModel.mat[n3].rowNr] * lpModel.mat[n3].value;
                    ++n3;
                }
                dArray[n2] = d;
            }
            ++n;
        }
        n = 1;
        while (n <= lpModel.sum) {
            dArray[n] = this.myRound(dArray[n], lpModel.epsd);
            ++n;
        }
    }

    void invert(LpModel lpModel) throws Exception {
        int n;
        double d;
        int n2;
        if (lpModel.printAtInvert != 0) {
            this.print("Start Invert iter " + lpModel.iter + " etaSize " + lpModel.etaSize + " rhs[0] " + -lpModel.rhs[0] + " \n");
        }
        int[] nArray = new int[lpModel.rows + 1];
        int[] nArray2 = new int[lpModel.rows + 1];
        int[] nArray3 = new int[lpModel.rows + 1];
        double[] dArray = new double[lpModel.rows + 1];
        int[] nArray4 = new int[lpModel.columns + 1];
        int n3 = 0;
        while (n3 <= lpModel.columns) {
            nArray4[n3] = 0;
            ++n3;
        }
        int[] nArray5 = new int[lpModel.rows + 1];
        n3 = 0;
        while (n3 <= lpModel.rows) {
            nArray5[n3] = 1;
            ++n3;
        }
        n3 = 0;
        while (n3 <= lpModel.rows) {
            if (lpModel.bas[n3] > lpModel.rows) {
                nArray4[lpModel.bas[n3] - lpModel.rows - 1] = 1;
            } else {
                nArray5[lpModel.bas[n3]] = 0;
            }
            ++n3;
        }
        int[] nArray6 = new int[lpModel.columns + 1];
        n3 = 0;
        while (n3 <= lpModel.columns) {
            nArray6[n3] = 0;
            ++n3;
        }
        n3 = 1;
        while (n3 <= lpModel.rows) {
            if (nArray5[n3] != 0) {
                n2 = lpModel.rowEnd[n3 - 1] + 1;
                while (n2 <= lpModel.rowEnd[n3]) {
                    int n4 = lpModel.colNo[n2];
                    if (nArray4[n4 - 1] != 0) {
                        int n5 = n4;
                        nArray6[n5] = nArray6[n5] + 1;
                        int n6 = n3 - 1;
                        nArray[n6] = nArray[n6] + 1;
                    }
                    ++n2;
                }
            }
            ++n3;
        }
        n3 = 1;
        while (n3 <= lpModel.rows) {
            lpModel.bas[n3] = n3;
            ++n3;
        }
        n3 = 1;
        while (n3 <= lpModel.rows) {
            lpModel.basis[n3] = 1;
            ++n3;
        }
        n3 = 1;
        while (n3 <= lpModel.columns) {
            lpModel.basis[n3 + lpModel.rows] = 0;
            ++n3;
        }
        n3 = 0;
        while (n3 <= lpModel.rows) {
            lpModel.rhs[n3] = lpModel.rh[n3];
            ++n3;
        }
        n3 = 1;
        while (n3 <= lpModel.columns) {
            int n7 = lpModel.rows + n3;
            if (lpModel.lower[n7] == 0) {
                d = lpModel.upperBound[n7];
                n2 = lpModel.colEnd[n3 - 1];
                while (n2 < lpModel.colEnd[n3]) {
                    int n8 = lpModel.mat[n2].rowNr;
                    lpModel.rhs[n8] = lpModel.rhs[n8] - d * lpModel.mat[n2].value;
                    ++n2;
                }
            }
            ++n3;
        }
        n3 = 1;
        while (n3 <= lpModel.rows) {
            if (lpModel.lower[n3] == 0) {
                int n9 = n3;
                lpModel.rhs[n9] = lpModel.rhs[n9] - lpModel.upperBound[n3];
            }
            ++n3;
        }
        lpModel.etaSize = 0;
        int n10 = 0;
        int n11 = 0;
        lpModel.numInv = 0;
        int n12 = 0;
        while (n10 < lpModel.rows) {
            if (++n11 > lpModel.rows) {
                n11 = 1;
            }
            ++n10;
            if (nArray[n11 - 1] != 1 || nArray5[n11] == 0) continue;
            n10 = 0;
            n2 = lpModel.rowEnd[n11 - 1] + 1;
            while (nArray4[lpModel.colNo[n2] - 1] == 0) {
                ++n2;
            }
            n = lpModel.colNo[n2];
            nArray4[n - 1] = 0;
            nArray6[n] = 0;
            n2 = lpModel.colEnd[n - 1];
            while (n2 < lpModel.colEnd[n]) {
                if (nArray5[lpModel.mat[n2].rowNr] != 0) {
                    int n13 = lpModel.mat[n2].rowNr - 1;
                    nArray[n13] = nArray[n13] - 1;
                }
                ++n2;
            }
            nArray5[n11] = 0;
            this.minorIteration(lpModel, n, n11);
        }
        n10 = 0;
        n = 0;
        while (n10 < lpModel.columns) {
            if (++n > lpModel.columns) {
                n = 1;
            }
            ++n10;
            if (nArray6[n] != 1 || nArray4[n - 1] == 0) continue;
            n10 = 0;
            n2 = lpModel.colEnd[n - 1] + 1;
            while (nArray5[lpModel.mat[n2 - 1].rowNr] == 0) {
                ++n2;
            }
            n11 = lpModel.mat[n2 - 1].rowNr;
            nArray5[n11] = 0;
            nArray[n11 - 1] = 0;
            n2 = lpModel.rowEnd[n11 - 1] + 1;
            while (n2 <= lpModel.rowEnd[n11]) {
                if (nArray4[lpModel.colNo[n2] - 1] != 0) {
                    int n14 = lpModel.colNo[n2];
                    nArray6[n14] = nArray6[n14] - 1;
                }
                ++n2;
            }
            nArray4[n - 1] = 0;
            nArray2[++n12 - 1] = n;
            nArray3[n12 - 1] = n11;
        }
        n2 = 1;
        while (n2 <= lpModel.columns) {
            if (nArray4[n2 - 1] != 0) {
                nArray4[n2 - 1] = 0;
                this.setPivotColumn(lpModel, lpModel.lower[lpModel.rows + n2], n2 + lpModel.rows, dArray);
                n11 = 1;
                while (n11 <= lpModel.rows && (nArray5[n11] == 0 || dArray[n11] == 0.0)) {
                    ++n11;
                }
                if (n11 > lpModel.rows) {
                    throw new Exception("Inverting failed");
                }
                nArray5[n11] = 0;
                lpModel.condenseColumn(n11, dArray);
                d = lpModel.rhs[n11] / dArray[n11];
                this.rhsMinColumn(lpModel, d, n11, lpModel.rows + n2);
                this.addEtaColumn(lpModel);
            }
            ++n2;
        }
        n3 = n12 - 1;
        while (n3 >= 0) {
            n = nArray2[n3];
            n11 = nArray3[n3];
            int n15 = n + lpModel.rows;
            n2 = 0;
            while (n2 <= lpModel.rows) {
                dArray[n2] = 0.0;
                ++n2;
            }
            n2 = lpModel.colEnd[n - 1];
            while (n2 < lpModel.colEnd[n]) {
                dArray[lpModel.mat[n2].rowNr] = lpModel.mat[n2].value;
                ++n2;
            }
            dArray[0] = dArray[0] - this.Extrad;
            lpModel.condenseColumn(n11, dArray);
            d = lpModel.rhs[n11] / dArray[n11];
            this.rhsMinColumn(lpModel, d, n11, n15);
            this.addEtaColumn(lpModel);
            --n3;
        }
        n3 = 1;
        while (n3 <= lpModel.rows) {
            lpModel.rhs[n3] = this.myRound(lpModel.rhs[n3], lpModel.epsb);
            ++n3;
        }
        if (lpModel.printAtInvert != 0) {
            this.print("End Invert                etaSize " + lpModel.etaSize + " rhs[0] " + -lpModel.rhs[0] + "\n");
        }
        this.JustInverted = 1;
        this.DoInvert = 0;
    }

    private int columnPrimal(LpModel lpModel, DoubleReference doubleReference, int n, double[] dArray) throws Exception {
        double d;
        int n2;
        double d2 = -lpModel.epsd;
        doubleReference.value = 0.0;
        if (n == 0) {
            n2 = 1;
            while (n2 <= lpModel.sum) {
                dArray[n2] = 0.0;
                ++n2;
            }
            dArray[0] = 1.0;
            lpModel.btran(dArray);
            n2 = 1;
            while (n2 <= lpModel.columns) {
                int n3 = lpModel.rows + n2;
                if (lpModel.basis[n3] == 0 && lpModel.upperBound[n3] > 0.0) {
                    d = 0.0;
                    int n4 = lpModel.colEnd[n2 - 1];
                    while (n4 < lpModel.colEnd[n2]) {
                        d += dArray[lpModel.mat[n4].rowNr] * lpModel.mat[n4].value;
                        ++n4;
                    }
                    dArray[n3] = d;
                }
                ++n2;
            }
            n2 = 1;
            while (n2 <= lpModel.sum) {
                dArray[n2] = this.myRound(dArray[n2], lpModel.epsd);
                ++n2;
            }
        }
        n2 = 1;
        while (n2 <= lpModel.sum) {
            if (lpModel.basis[n2] == 0 && lpModel.upperBound[n2] > 0.0 && (d = lpModel.lower[n2] != 0 ? dArray[n2] : -dArray[n2]) < d2) {
                d2 = d;
                doubleReference.value = n2;
            }
            ++n2;
        }
        if (lpModel.trace != 0) {
            if (doubleReference.value > 0.0) {
                this.println("col_prim:" + doubleReference.value + ", reduced cost: " + d2);
            } else {
                this.println("col_prim: no negative reduced costs found, optimality!");
            }
        }
        if (doubleReference.value == 0.0) {
            this.DoIter = 0;
            this.DoInvert = 0;
            this.Status = 0;
        }
        return doubleReference.value > 0.0 ? 1 : 0;
    }

    private int rowPrimal(LpModel lpModel, int n, DoubleReference doubleReference, DoubleReference doubleReference2, double[] dArray) throws Exception {
        double d;
        double d2 = 0.0;
        doubleReference.value = 0.0;
        doubleReference2.value = lpModel.infinite;
        int n2 = 1;
        while (n2 <= lpModel.rows) {
            d2 = dArray[n2];
            if (d2 != 0.0) {
                if (Math.abs(d2) < this.Trej) {
                    lpModel.debugPrint(this.Level, "pivot " + d2 + " rejected, too small (limit " + this.Trej + ")\n");
                } else {
                    d = 2.0 * lpModel.infinite;
                    if (d2 > 0.0) {
                        d = lpModel.rhs[n2] / d2;
                    } else if (lpModel.upperBound[lpModel.bas[n2]] < lpModel.infinite) {
                        d = (lpModel.rhs[n2] - lpModel.upperBound[lpModel.bas[n2]]) / d2;
                    }
                    d = this.myRound(d, lpModel.epsel);
                    if (d < doubleReference2.value) {
                        doubleReference2.value = d;
                        doubleReference.value = n2;
                    }
                }
            }
            ++n2;
        }
        if (doubleReference.value == 0.0) {
            n2 = 1;
            while (n2 <= lpModel.rows) {
                d2 = dArray[n2];
                if (d2 != 0.0) {
                    d = 2.0 * lpModel.infinite;
                    if (d2 > 0.0) {
                        d = lpModel.rhs[n2] / d2;
                    } else if (lpModel.upperBound[lpModel.bas[n2]] < lpModel.infinite) {
                        d = (lpModel.rhs[n2] - lpModel.upperBound[lpModel.bas[n2]]) / d2;
                    }
                    d = this.myRound(d, lpModel.epsel);
                    if (d < doubleReference2.value) {
                        doubleReference2.value = d;
                        doubleReference.value = n2;
                    }
                }
                ++n2;
            }
        }
        if (doubleReference2.value < 0.0) {
            System.err.println("Warning: Numerical instability, qout = " + doubleReference2.value);
            System.err.println("pcol[" + doubleReference.value + "] = " + d2 + ", rhs[" + doubleReference.value + "] = " + lpModel.rhs[(int)doubleReference.value] + " , upperBound = " + lpModel.upperBound[lpModel.bas[(int)doubleReference.value]]);
        }
        if (doubleReference.value == 0.0) {
            if (lpModel.upperBound[n] == lpModel.infinite) {
                this.DoIter = 0;
                this.DoInvert = 0;
                this.Status = 3;
            } else {
                n2 = 1;
                while (n2 <= lpModel.rows && dArray[n2] >= 0.0) {
                    ++n2;
                }
                if (n2 > lpModel.rows) {
                    lpModel.lower[n] = 0;
                    lpModel.rhs[0] = lpModel.rhs[0] + lpModel.upperBound[n] * dArray[0];
                    this.DoIter = 0;
                    this.DoInvert = 0;
                } else if (dArray[n2] < 0.0) {
                    doubleReference.value = n2;
                }
            }
        }
        if (doubleReference.value > 0.0) {
            this.DoIter = 1;
        }
        if (lpModel.trace != 0) {
            this.println("row_prim:" + doubleReference.value + ", pivot element:" + dArray[(int)doubleReference.value]);
        }
        return doubleReference.value > 0.0 ? 1 : 0;
    }

    private int rowDual(LpModel lpModel, DoubleReference doubleReference) throws Exception {
        doubleReference.value = 0.0;
        double d = -lpModel.epsb;
        int n = 0;
        boolean bl = false;
        while (n < lpModel.rows && !bl) {
            double d2;
            if ((d2 = lpModel.upperBound[lpModel.bas[++n]]) == 0.0 && lpModel.rhs[n] != 0.0) {
                bl = true;
                doubleReference.value = n;
                continue;
            }
            double d3 = lpModel.rhs[n] < d2 - lpModel.rhs[n] ? lpModel.rhs[n] : d2 - lpModel.rhs[n];
            if (!(d3 < d)) continue;
            d = d3;
            doubleReference.value = n;
        }
        if (lpModel.trace != 0) {
            if (doubleReference.value > 0.0) {
                this.println("row_dual:" + doubleReference.value + ", rhs of selected row:           " + lpModel.rhs[(int)doubleReference.value]);
                if (lpModel.upperBound[lpModel.bas[(int)doubleReference.value]] < lpModel.infinite) {
                    this.println("               upper bound of basis variable:    " + lpModel.upperBound[lpModel.bas[(int)doubleReference.value]]);
                }
            } else {
                this.println("row_dual: no infeasibilities found\n");
            }
        }
        return doubleReference.value > 0.0 ? 1 : 0;
    }

    private int columnDual(LpModel lpModel, int n, DoubleReference doubleReference, int n2, double[] dArray, double[] dArray2) throws Exception {
        double d;
        int n3;
        this.DoIter = 0;
        if (n2 == 0) {
            int n4;
            double d2;
            n3 = 0;
            while (n3 <= lpModel.rows) {
                dArray[n3] = 0.0;
                dArray2[n3] = 0.0;
                ++n3;
            }
            dArray2[0] = 1.0;
            dArray[n] = 1.0;
            n3 = lpModel.etaSize;
            while (n3 >= 1) {
                d = 0.0;
                d2 = 0.0;
                int n5 = lpModel.etaRowNr[lpModel.etaColEnd[n3] - 1];
                n4 = lpModel.etaColEnd[n3 - 1];
                while (n4 < lpModel.etaColEnd[n3]) {
                    d2 += dArray[lpModel.etaRowNr[n4]] * lpModel.etaValue[n4];
                    d += dArray2[lpModel.etaRowNr[n4]] * lpModel.etaValue[n4];
                    ++n4;
                }
                dArray[n5] = d2 = this.myRound(d2, lpModel.epsel);
                dArray2[n5] = d = this.myRound(d, lpModel.epsel);
                --n3;
            }
            n3 = 1;
            while (n3 <= lpModel.columns) {
                int n6 = lpModel.rows + n3;
                if (lpModel.basis[n6] == 0) {
                    d = -this.Extrad * dArray2[0];
                    d2 = 0.0;
                    n4 = lpModel.colEnd[n3 - 1];
                    while (n4 < lpModel.colEnd[n3]) {
                        d += dArray2[lpModel.mat[n4].rowNr] * lpModel.mat[n4].value;
                        d2 += dArray[lpModel.mat[n4].rowNr] * lpModel.mat[n4].value;
                        ++n4;
                    }
                    dArray[n6] = d2 = this.myRound(d2, lpModel.epsel);
                    dArray2[n6] = d = this.myRound(d, lpModel.epsd);
                }
                ++n3;
            }
        }
        double d3 = lpModel.rhs[n] > lpModel.upperBound[lpModel.bas[n]] ? -1.0 : 1.0;
        double d4 = 0.0;
        doubleReference.value = 0.0;
        double d5 = lpModel.infinite;
        n3 = 1;
        while (n3 <= lpModel.sum) {
            d = lpModel.lower[n3] != 0 ? dArray[n3] * d3 : -dArray[n3] * d3;
            if (d < 0.0 && lpModel.basis[n3] == 0 && lpModel.upperBound[n3] > 0.0) {
                double d6 = lpModel.lower[n3] != 0 ? -dArray2[n3] / d : dArray2[n3] / d;
                if (d6 < d5) {
                    d5 = d6;
                    d4 = d;
                    doubleReference.value = n3;
                } else if (d6 == d5 && Math.abs(d) > Math.abs(d4)) {
                    d4 = d;
                    doubleReference.value = n3;
                }
            }
            ++n3;
        }
        if (lpModel.trace != 0) {
            this.println("col_dual:" + doubleReference.value + ", pivot element:  " + dArray[(int)doubleReference.value]);
        }
        if (doubleReference.value > 0.0) {
            this.DoIter = 1;
        }
        return doubleReference.value > 0.0 ? 1 : 0;
    }

    void iteration(LpModel lpModel, int n, int n2, DoubleReference doubleReference, double d, DoubleReference doubleReference2, DoubleReference doubleReference3, int n3) throws Exception {
        double d2;
        ++lpModel.iter;
        if (this.viewer != null) {
            this.viewer.stepUpdate(lpModel.iter);
        }
        if (this.state == 4) {
            if (this.viewer != null) {
                this.viewer.stateChanged();
            }
            this.wait();
        }
        double d3 = doubleReference2.value = doubleReference.value > d + lpModel.epsb ? 1.0 : 0.0;
        if (doubleReference2.value != 0.0) {
            doubleReference.value = d;
            doubleReference3.value = doubleReference3.value == 0.0 ? 1.0 : 0.0;
        }
        int n4 = lpModel.etaColEnd[lpModel.etaSize + 1];
        double d4 = lpModel.etaValue[n4 - 1];
        int n5 = lpModel.etaColEnd[lpModel.etaSize];
        while (n5 < n4) {
            d2 = lpModel.rhs[lpModel.etaRowNr[n5]] - doubleReference.value * lpModel.etaValue[n5];
            lpModel.rhs[lpModel.etaRowNr[n5]] = d2 = this.myRound(d2, lpModel.epsb);
            ++n5;
        }
        if (doubleReference2.value == 0.0) {
            lpModel.rhs[n] = doubleReference.value;
            int n6 = lpModel.bas[n];
            lpModel.bas[n] = n2;
            lpModel.basis[n6] = 0;
            lpModel.basis[n2] = 1;
            if (n3 != 0 && d4 < 0.0) {
                lpModel.lower[n6] = 0;
            }
            if (doubleReference3.value == 0.0 && d < lpModel.infinite) {
                doubleReference3.value = 1.0;
                lpModel.rhs[n] = d - lpModel.rhs[n];
                n5 = lpModel.etaColEnd[lpModel.etaSize];
                while (n5 < n4) {
                    lpModel.etaValue[n5] = -lpModel.etaValue[n5];
                    ++n5;
                }
            }
            this.addEtaColumn(lpModel);
            ++lpModel.numInv;
        }
        if (lpModel.trace != 0) {
            this.println("Theta = " + doubleReference.value + " ");
            if (doubleReference2.value != 0.0) {
                if (lpModel.lower[n2] == 0) {
                    this.print("Iteration:" + lpModel.iter + ", variable" + n2 + " changed from 0 to its upper bound of " + lpModel.upperBound[n2] + "\n");
                } else {
                    this.print("Iteration:" + lpModel.iter + ", variable" + n2 + " changed its upper bound of " + lpModel.upperBound[n2] + " to 0\n");
                }
            } else {
                this.print("Iteration:" + lpModel.iter + ", variable" + n2 + " entered basis at:" + lpModel.rhs[n] + "\n");
            }
            if (n3 == 0) {
                d2 = 0.0;
                n5 = 1;
                while (n5 <= lpModel.rows) {
                    if (lpModel.rhs[n5] < 0.0) {
                        d2 -= lpModel.rhs[n5];
                    } else if (lpModel.rhs[n5] > lpModel.upperBound[lpModel.bas[n5]]) {
                        d2 += lpModel.rhs[n5] - lpModel.upperBound[lpModel.bas[n5]];
                    }
                    ++n5;
                }
                this.println("feasibility gap of this basis:" + d2);
            } else {
                this.println("objective function value of this feasible basis: " + lpModel.rhs[0]);
            }
        }
    }

    void presolve(LpModel lpModel) {
        this.print("Entering presolve\n");
    }

    private int solveLp(LpModel lpModel) throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        int n = -10000;
        int n2 = -10000;
        DoubleReference doubleReference = new DoubleReference(0.0);
        DoubleReference doubleReference2 = new DoubleReference(0.0);
        DoubleReference doubleReference3 = new DoubleReference(0.0);
        if (lpModel.doPresolve != 0) {
            this.presolve(lpModel);
        }
        double[] dArray = new double[lpModel.sum + 1];
        double[] dArray2 = new double[lpModel.sum + 1];
        double[] dArray3 = new double[lpModel.rows + 1];
        int[] nArray = new int[lpModel.sum + 1];
        lpModel.iter = 0;
        int n3 = 0;
        this.Status = 5;
        this.DoInvert = 0;
        this.DoIter = 0;
        int n4 = 1;
        int n5 = 1;
        while (n4 <= lpModel.rows && n5 != 0) {
            n5 = lpModel.rhs[n4] >= 0.0 && lpModel.rhs[n4] <= lpModel.upperBound[lpModel.bas[n4]] ? 1 : 0;
            ++n4;
        }
        if (lpModel.trace != 0) {
            if (n5 != 0) {
                this.println("Start at feasible basis");
            } else {
                this.println("Start at infeasible basis");
            }
        }
        if (n5 == 0) {
            dArray[0] = 1.0;
            n4 = 1;
            while (n4 <= lpModel.rows) {
                dArray[n4] = 0.0;
                ++n4;
            }
            lpModel.btran(dArray);
            this.Extrad = 0.0;
            n4 = 1;
            while (n4 <= lpModel.columns) {
                int n6 = lpModel.rows + n4;
                dArray[n6] = 0.0;
                int n7 = lpModel.colEnd[n4 - 1];
                while (n7 < lpModel.colEnd[n4]) {
                    if (dArray[lpModel.mat[n7].rowNr] != 0.0) {
                        int n8 = n6;
                        dArray[n8] = dArray[n8] + dArray[lpModel.mat[n7].rowNr] * lpModel.mat[n7].value;
                    }
                    ++n7;
                }
                if (dArray[n6] < this.Extrad) {
                    this.Extrad = dArray[n6];
                }
                ++n4;
            }
        } else {
            this.Extrad = 0.0;
        }
        if (lpModel.trace != 0) {
            this.println("Extrad = " + this.Extrad);
        }
        n3 = 0;
        while (this.Status == 5) {
            int n9;
            this.DoIter = 0;
            this.DoInvert = 0;
            if (n5 != 0) {
                n = 0;
                doubleReference.value = n;
                n9 = this.columnPrimal(lpModel, doubleReference, n3, dArray);
                n = (int)doubleReference.value;
                if (n9 != 0) {
                    this.setPivotColumn(lpModel, lpModel.lower[n], n, dArray3);
                    n2 = 0;
                    d2 = 0.0;
                    doubleReference.value = n2;
                    doubleReference2.value = d2;
                    n9 = this.rowPrimal(lpModel, n, doubleReference, doubleReference2, dArray3);
                    n2 = (int)doubleReference.value;
                    d2 = doubleReference2.value;
                    if (n9 != 0) {
                        lpModel.condenseColumn(n2, dArray3);
                    }
                }
            } else {
                if (n3 == 0) {
                    n2 = 0;
                    doubleReference.value = n2;
                    this.rowDual(lpModel, doubleReference);
                    n2 = (int)doubleReference.value;
                }
                if (n2 > 0) {
                    n = 0;
                    doubleReference.value = n;
                    n9 = this.columnDual(lpModel, n2, doubleReference, n3, dArray2, dArray);
                    n = (int)doubleReference.value;
                    if (n9 != 0) {
                        this.setPivotColumn(lpModel, lpModel.lower[n], n, dArray3);
                        if (dArray3[n2] == 0.0) {
                            this.println("An attempt was made to divide by zero (Pcol[" + n2 + "])");
                            this.println("This indicates numerical instability");
                            this.DoIter = 0;
                            if (this.JustInverted == 0) {
                                this.println("Trying to recover. Reinverting Eta");
                                this.DoInvert = 1;
                            } else {
                                this.println("Can't reinvert, failure");
                                this.Status = 4;
                            }
                        } else {
                            lpModel.condenseColumn(n2, dArray3);
                            d = lpModel.rhs[n2] - lpModel.upperBound[lpModel.bas[n2]];
                            if (d > 0.0) {
                                d2 = d / dArray3[n2];
                                if (d2 <= lpModel.upperBound[n]) {
                                    lpModel.lower[lpModel.bas[n2]] = 1 - lpModel.lower[lpModel.bas[n2]];
                                }
                            } else {
                                d2 = lpModel.rhs[n2] / dArray3[n2];
                            }
                        }
                    } else {
                        this.Status = 2;
                    }
                } else {
                    n5 = 1;
                    this.DoIter = 0;
                    this.Extrad = 0.0;
                    this.DoInvert = 1;
                }
            }
            if (this.DoIter != 0) {
                doubleReference.value = d2;
                doubleReference2.value = n3;
                doubleReference3.value = lpModel.lower[n];
                this.iteration(lpModel, n2, n, doubleReference, lpModel.upperBound[n], doubleReference2, doubleReference3, n5);
                d2 = doubleReference.value;
                n3 = (int)doubleReference2.value;
                lpModel.lower[n] = (int)doubleReference3.value;
            }
            if (lpModel.numInv >= lpModel.maxNumInv) {
                this.DoInvert = 1;
            }
            if (this.DoInvert == 0) continue;
            if (lpModel.printAtInvert != 0) {
                this.println("Inverting: Primal = " + n5);
            }
            this.invert(lpModel);
        }
        lpModel.totalIter += lpModel.iter;
        return this.Status;
    }

    int isInt(LpModel lpModel, int n) throws Exception {
        double d = lpModel.solution[n];
        double d2 = d - Math.floor(d);
        if (d2 < lpModel.epsilon) {
            return 1;
        }
        if (d2 > 1.0 - lpModel.epsilon) {
            return 1;
        }
        return 0;
    }

    private void constructSolution(LpModel lpModel) throws Exception {
        Arrays.fill(lpModel.solution, 0.0);
        lpModel.solution[0] = -lpModel.origRh[0];
        if (lpModel.scalingUsed != 0) {
            lpModel.solution[0] = lpModel.solution[0] / lpModel.scale[0];
            int n = lpModel.rows + 1;
            while (n <= lpModel.sum) {
                lpModel.solution[n] = lpModel.lowerBound[n] * lpModel.scale[n];
                ++n;
            }
            n = 1;
            while (n <= lpModel.rows) {
                int n2 = lpModel.bas[n];
                if (n2 > lpModel.rows) {
                    int n3 = n2;
                    lpModel.solution[n3] = lpModel.solution[n3] + lpModel.rhs[n] * lpModel.scale[n2];
                }
                ++n;
            }
            n = lpModel.rows + 1;
            while (n <= lpModel.sum) {
                if (lpModel.basis[n] == 0 && lpModel.lower[n] == 0) {
                    int n4 = n;
                    lpModel.solution[n4] = lpModel.solution[n4] + lpModel.upperBound[n] * lpModel.scale[n];
                }
                ++n;
            }
            int n5 = 1;
            while (n5 <= lpModel.columns) {
                double d = lpModel.solution[lpModel.rows + n5];
                if (d != 0.0) {
                    n = lpModel.colEnd[n5 - 1];
                    while (n < lpModel.colEnd[n5]) {
                        int n6 = lpModel.mat[n].rowNr;
                        lpModel.solution[n6] = lpModel.solution[n6] + d / lpModel.scale[lpModel.rows + n5] * (lpModel.mat[n].value / lpModel.scale[lpModel.mat[n].rowNr]);
                        ++n;
                    }
                }
                ++n5;
            }
            n = 0;
            while (n <= lpModel.rows) {
                if (Math.abs(lpModel.solution[n]) < lpModel.epsb) {
                    lpModel.solution[n] = 0.0;
                } else if (lpModel.changedSign[n] != 0) {
                    lpModel.solution[n] = -lpModel.solution[n];
                }
                ++n;
            }
        } else {
            int n = lpModel.rows + 1;
            while (n <= lpModel.sum) {
                lpModel.solution[n] = lpModel.lowerBound[n];
                ++n;
            }
            n = 1;
            while (n <= lpModel.rows) {
                int n7 = lpModel.bas[n];
                if (n7 > lpModel.rows) {
                    int n8 = n7;
                    lpModel.solution[n8] = lpModel.solution[n8] + lpModel.rhs[n];
                }
                ++n;
            }
            n = lpModel.rows + 1;
            while (n <= lpModel.sum) {
                if (lpModel.basis[n] == 0 && lpModel.lower[n] == 0) {
                    int n9 = n;
                    lpModel.solution[n9] = lpModel.solution[n9] + lpModel.upperBound[n];
                }
                ++n;
            }
            int n10 = 1;
            while (n10 <= lpModel.columns) {
                double d = lpModel.solution[lpModel.rows + n10];
                if (d != 0.0) {
                    n = lpModel.colEnd[n10 - 1];
                    while (n < lpModel.colEnd[n10]) {
                        int n11 = lpModel.mat[n].rowNr;
                        lpModel.solution[n11] = lpModel.solution[n11] + d * lpModel.mat[n].value;
                        ++n;
                    }
                }
                ++n10;
            }
            n = 0;
            while (n <= lpModel.rows) {
                if (Math.abs(lpModel.solution[n]) < lpModel.epsb) {
                    lpModel.solution[n] = 0.0;
                } else if (lpModel.changedSign[n] != 0) {
                    lpModel.solution[n] = -lpModel.solution[n];
                }
                ++n;
            }
        }
    }

    private void calculateDuals(LpModel lpModel) throws Exception {
        lpModel.duals[0] = 1.0;
        int n = 1;
        while (n <= lpModel.rows) {
            lpModel.duals[n] = 0.0;
            ++n;
        }
        lpModel.btran(lpModel.duals);
        if (lpModel.scalingUsed != 0) {
            n = 1;
            while (n <= lpModel.rows) {
                int n2 = n;
                lpModel.duals[n2] = lpModel.duals[n2] * (lpModel.scale[n] / lpModel.scale[0]);
                ++n;
            }
        }
        n = 1;
        while (n <= lpModel.rows) {
            if (lpModel.basis[n] != 0) {
                lpModel.duals[n] = 0.0;
            } else if (lpModel.changedSign[0] == lpModel.changedSign[n] && lpModel.duals[n] != 0.0) {
                lpModel.duals[n] = -lpModel.duals[n];
            }
            ++n;
        }
    }

    private void checkIfLess(double d, double d2, double d3) {
        if (d >= d2) {
            this.viewer.errorMessage("Error: new upper or lower bound is not more restrictive\n");
            this.viewer.errorMessage("bound 1: " + d + ", bound 2: " + d2 + ", value: " + d3);
        }
    }

    private void checkSolution(LpModel lpModel, double[] dArray, double[] dArray2) throws Exception {
        double d = 0.01;
        if (lpModel.columnsScaled != 0) {
            int n = lpModel.rows + 1;
            while (n <= lpModel.sum) {
                if (lpModel.solution[n] < dArray2[n] * lpModel.scale[n] - d) {
                    this.viewer.errorMessage("Error: variable " + (n - lpModel.rows) + " (" + lpModel.colName[n - lpModel.rows] + ") has a solution (" + lpModel.solution[n] + ") smaller than its lower bound (" + dArray2[n] * lpModel.scale[n] + ")");
                }
                if (lpModel.solution[n] > dArray[n] * lpModel.scale[n] + d) {
                    this.viewer.errorMessage("Error: variable " + (n - lpModel.rows) + " (" + lpModel.colName[n - lpModel.rows] + ") has a solution (" + lpModel.solution[n] + ") larger than its upper bound (" + dArray[n] * lpModel.scale[n] + ")\n");
                }
                ++n;
            }
        } else {
            int n = lpModel.rows + 1;
            while (n <= lpModel.sum) {
                if (lpModel.solution[n] < dArray2[n] - d) {
                    this.viewer.errorMessage("Error: variable " + (n - lpModel.rows) + " (" + lpModel.colName[n - lpModel.rows] + ") has a solution (" + lpModel.solution[n] + ") smaller than its lower bound (" + dArray2[n] + ")");
                }
                if (lpModel.solution[n] > dArray[n] + d) {
                    this.viewer.errorMessage("Error: variable " + (n - lpModel.rows) + " (" + lpModel.colName[n - lpModel.rows] + ") has a solution (" + lpModel.solution[n] + ") larger than its upper bound (" + dArray[n] + ")");
                }
                ++n;
            }
        }
    }

    private int milpsolve(LpModel lpModel, double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, int[] nArray3, int n) throws Exception {
        int n2;
        double d;
        int n3;
        int n4 = Integer.MIN_VALUE;
        Random random = new Random();
        if (this.Break_bb != 0) {
            return 8;
        }
        ++this.Level;
        ++lpModel.totalNodes;
        if (this.Level > lpModel.maxLevel) {
            lpModel.maxLevel = this.Level;
        }
        lpModel.debugPrint(this.Level, "starting solve");
        System.arraycopy(dArray, 0, lpModel.upperBound, 0, lpModel.sum + 1);
        System.arraycopy(dArray2, 0, lpModel.lowerBound, 0, lpModel.sum + 1);
        System.arraycopy(lpModel.origRh, 0, lpModel.rh, 0, lpModel.rows + 1);
        if (n != 0) {
            System.arraycopy(nArray, 0, lpModel.basis, 0, lpModel.sum + 1);
            System.arraycopy(nArray2, 0, lpModel.lower, 0, lpModel.sum + 1);
            System.arraycopy(nArray3, 0, lpModel.bas, 0, lpModel.rows + 1);
        }
        if (lpModel.antiDegen != 0) {
            n3 = 1;
            while (n3 <= lpModel.columns) {
                double d2 = random.nextDouble() * 0.001;
                if (d2 > lpModel.epsb) {
                    int n5 = n3 + lpModel.rows;
                    lpModel.lowerBound[n5] = lpModel.lowerBound[n5] - d2;
                }
                if ((d2 = random.nextDouble() * 0.001) > lpModel.epsb) {
                    int n6 = n3 + lpModel.rows;
                    lpModel.upperBound[n6] = lpModel.upperBound[n6] + d2;
                }
                ++n3;
            }
            lpModel.etaValid = 0;
        }
        if (lpModel.etaValid == 0) {
            n3 = 1;
            while (n3 <= lpModel.columns) {
                d = lpModel.lowerBound[lpModel.rows + n3];
                if (d != 0.0) {
                    if (lpModel.upperBound[lpModel.rows + n3] < lpModel.infinite) {
                        int n7 = lpModel.rows + n3;
                        lpModel.upperBound[n7] = lpModel.upperBound[n7] - d;
                    }
                    n2 = lpModel.colEnd[n3 - 1];
                    while (n2 < lpModel.colEnd[n3]) {
                        int n8 = lpModel.mat[n2].rowNr;
                        lpModel.rh[n8] = lpModel.rh[n8] - d * lpModel.mat[n2].value;
                        ++n2;
                    }
                }
                ++n3;
            }
            this.invert(lpModel);
            lpModel.etaValid = 1;
        }
        int n9 = this.solveLp(lpModel);
        if (lpModel.antiDegen != 0 && n9 == 0) {
            System.arraycopy(dArray, 0, lpModel.upperBound, 0, lpModel.sum + 1);
            System.arraycopy(dArray2, 0, lpModel.lowerBound, 0, lpModel.sum + 1);
            System.arraycopy(lpModel.origRh, 0, lpModel.rh, 0, lpModel.rows + 1);
            n3 = 1;
            while (n3 <= lpModel.columns) {
                d = lpModel.lowerBound[lpModel.rows + n3];
                if (d != 0.0) {
                    if (lpModel.upperBound[lpModel.rows + n3] < lpModel.infinite) {
                        int n10 = lpModel.rows + n3;
                        lpModel.upperBound[n10] = lpModel.upperBound[n10] - d;
                    }
                    n2 = lpModel.colEnd[n3 - 1];
                    while (n2 < lpModel.colEnd[n3]) {
                        int n11 = lpModel.mat[n2].rowNr;
                        lpModel.rh[n11] = lpModel.rh[n11] - d * lpModel.mat[n2].value;
                        ++n2;
                    }
                }
                ++n3;
            }
            this.invert(lpModel);
            lpModel.etaValid = 1;
            n9 = this.solveLp(lpModel);
        }
        if (n9 != 0) {
            lpModel.debugPrint(this.Level, "this problem has no solution, it is " + (n9 == 3 ? "unbounded" : "infeasible"));
        }
        if (n9 == 2 && lpModel.verbose != 0) {
            this.print("level" + this.Level + " INF\n");
        }
        if (n9 == 0) {
            boolean bl;
            this.constructSolution(lpModel);
            lpModel.debugPrint(this.Level, "a solution was found");
            lpModel.debugPrintSolution(this.Level);
            if (lpModel.maximise != 0) {
                bl = lpModel.solution[0] <= lpModel.bestSolution[0];
            } else {
                boolean bl2 = bl = lpModel.solution[0] >= lpModel.bestSolution[0];
            }
            if (bl) {
                if (lpModel.verbose != 0) {
                    this.println("level " + this.Level + " OPT NOB value " + lpModel.solution[0] + " bound " + lpModel.bestSolution[0]);
                }
                lpModel.debugPrint(this.Level, "but it was worse than the best sofar, discarded");
                --this.Level;
                return 1;
            }
            if (lpModel.bbRule == 0) {
                n4 = 0;
                n3 = lpModel.rows + 1;
                while (n3 <= lpModel.sum && n4 == 0) {
                    if (lpModel.mustBeInt[n3] != 0 && this.isInt(lpModel, n3) == 0) {
                        if (dArray2[n3] == dArray[n3]) {
                            System.err.println("Warning: integer var " + (n3 - lpModel.rows) + " is already fixed at " + dArray2[n3] + ", but has non-integer value " + lpModel.solution[n3]);
                            System.err.println("Perhaps the -e option should be used");
                        } else {
                            n4 = n3;
                        }
                    }
                    ++n3;
                }
            }
            if (lpModel.bbRule == 1) {
                int n12 = 0;
                n3 = lpModel.rows + 1;
                while (n3 <= lpModel.sum) {
                    if (lpModel.mustBeInt[n3] != 0 && this.isInt(lpModel, n3) == 0) {
                        ++n12;
                    }
                    ++n3;
                }
                if (n12 == 0) {
                    n4 = 0;
                } else {
                    int n13 = random.nextInt() % n12 + 1;
                    n3 = lpModel.rows + 1;
                    while (n13 > 0) {
                        if (lpModel.mustBeInt[n3] != 0 && this.isInt(lpModel, n3) == 0) {
                            --n13;
                        }
                        ++n3;
                    }
                    n4 = n3 - 1;
                }
            }
            if (n4 == Integer.MIN_VALUE) {
                throw new Exception("notint is not being initialized!");
            }
            if (lpModel.verbose != 0) {
                if (n4 != 0) {
                    this.println("level " + this.Level + " OPT     value " + lpModel.solution[0]);
                } else {
                    this.println("level " + this.Level + " OPT INT value " + lpModel.solution[0]);
                }
            }
            if (n4 != 0) {
                int n14;
                int n15;
                double[] dArray3 = new double[lpModel.sum + 1];
                double[] dArray4 = new double[lpModel.sum + 1];
                int[] nArray4 = new int[lpModel.sum + 1];
                int[] nArray5 = new int[lpModel.sum + 1];
                int[] nArray6 = new int[lpModel.rows + 1];
                System.arraycopy(dArray, 0, dArray3, 0, lpModel.sum + 1);
                System.arraycopy(dArray2, 0, dArray4, 0, lpModel.sum + 1);
                System.arraycopy(lpModel.lower, 0, nArray4, 0, lpModel.sum + 1);
                System.arraycopy(lpModel.basis, 0, nArray5, 0, lpModel.sum + 1);
                System.arraycopy(lpModel.bas, 0, nArray6, 0, lpModel.rows + 1);
                if (lpModel.namesUsed != 0) {
                    lpModel.debugPrint(this.Level, "not enough ints. Selecting var " + lpModel.colName[n4 - lpModel.rows] + ", val: " + lpModel.solution[n4]);
                } else {
                    lpModel.debugPrint(this.Level, "not enough ints. Selecting Var [" + n4 + "], val: " + lpModel.solution[n4]);
                }
                lpModel.debugPrint(this.Level, "current bounds:\n");
                lpModel.debugPrintBounds(this.Level, dArray, dArray2);
                if (lpModel.floorFirst != 0) {
                    double d3 = Math.ceil(lpModel.solution[n4]) - 1.0;
                    if (d3 < dArray2[n4]) {
                        lpModel.debugPrint(this.Level, "New upper bound value " + d3 + " conflicts with old lower bound " + dArray2[n4] + "\n");
                        n15 = 1;
                    } else {
                        this.checkIfLess(d3, dArray[n4], lpModel.solution[n4]);
                        dArray3[n4] = d3;
                        lpModel.debugPrint(this.Level, "starting first subproblem with bounds:");
                        lpModel.debugPrintBounds(this.Level, dArray3, dArray2);
                        lpModel.etaValid = 0;
                        n15 = this.milpsolve(lpModel, dArray3, dArray2, nArray5, nArray4, nArray6, 1);
                        lpModel.etaValid = 0;
                    }
                    d3 += 1.0;
                    if (d3 > dArray[n4]) {
                        lpModel.debugPrint(this.Level, "New lower bound value " + d3 + " conflicts with old upper bound " + dArray[n4] + "\n");
                        n14 = 1;
                    } else {
                        this.checkIfLess(dArray2[n4], d3, lpModel.solution[n4]);
                        dArray4[n4] = d3;
                        lpModel.debugPrint(this.Level, "starting second subproblem with bounds:");
                        lpModel.debugPrintBounds(this.Level, dArray, dArray4);
                        lpModel.etaValid = 0;
                        n14 = this.milpsolve(lpModel, dArray, dArray4, nArray5, nArray4, nArray6, 1);
                        lpModel.etaValid = 0;
                    }
                } else {
                    double d4 = Math.ceil(lpModel.solution[n4]);
                    if (d4 > dArray[n4]) {
                        lpModel.debugPrint(this.Level, "New lower bound value " + d4 + " conflicts with old upper bound " + dArray[n4] + "\n");
                        n15 = 1;
                    } else {
                        this.checkIfLess(dArray2[n4], d4, lpModel.solution[n4]);
                        dArray4[n4] = d4;
                        lpModel.debugPrint(this.Level, "starting first subproblem with bounds:");
                        lpModel.debugPrintBounds(this.Level, dArray, dArray4);
                        lpModel.etaValid = 0;
                        n15 = this.milpsolve(lpModel, dArray, dArray4, nArray5, nArray4, nArray6, 1);
                        lpModel.etaValid = 0;
                    }
                    d4 -= 1.0;
                    if (d4 < dArray2[n4]) {
                        lpModel.debugPrint(this.Level, "New upper bound value " + d4 + " conflicts with old lower bound " + dArray2[n4] + "\n");
                        n14 = 1;
                    } else {
                        this.checkIfLess(d4, dArray[n4], lpModel.solution[n4]);
                        dArray3[n4] = d4;
                        lpModel.debugPrint(this.Level, "starting second subproblem with bounds:");
                        lpModel.debugPrintBounds(this.Level, dArray3, dArray2);
                        lpModel.etaValid = 0;
                        n14 = this.milpsolve(lpModel, dArray3, dArray2, nArray5, nArray4, nArray6, 1);
                        lpModel.etaValid = 0;
                    }
                }
                n9 = n15 != 0 && n14 != 0 ? 2 : 0;
            } else {
                lpModel.debugPrint(this.Level, "--> valid solution found");
                if (lpModel.maximise != 0) {
                    bl = lpModel.solution[0] < lpModel.bestSolution[0];
                } else {
                    boolean bl3 = bl = lpModel.solution[0] > lpModel.bestSolution[0];
                }
                if (!bl) {
                    if (lpModel.debug != 0 || lpModel.verbose != 0 && lpModel.printSolution == 0) {
                        this.print("*** new best solution: old: " + lpModel.bestSolution[0] + ", new: " + lpModel.solution[0] + " ***\n");
                    }
                    System.arraycopy(lpModel.solution, 0, lpModel.bestSolution, 0, lpModel.sum + 1);
                    this.calculateDuals(lpModel);
                    if (lpModel.printSolution != 0) {
                        lpModel.printSolution();
                    }
                    if (lpModel.breakAtInt != 0) {
                        if (lpModel.maximise != 0 && lpModel.bestSolution[0] > lpModel.breakValue) {
                            this.Break_bb = 1;
                        }
                        if (lpModel.maximise == 0 && lpModel.bestSolution[0] < lpModel.breakValue) {
                            this.Break_bb = 1;
                        }
                    }
                }
            }
        }
        --this.Level;
        return n9;
    }

    public int solve() throws Exception {
        return this.solve(this.model);
    }

    private int solve(LpModel lpModel) throws Exception {
        lpModel.totalIter = 0;
        lpModel.maxLevel = 1;
        lpModel.totalNodes = 0;
        if (lpModel.isValid() != 0) {
            lpModel.bestSolution[0] = lpModel.maximise != 0 && lpModel.objBound == lpModel.infinite ? -lpModel.infinite : (lpModel.maximise == 0 && lpModel.objBound == -lpModel.infinite ? lpModel.infinite : lpModel.objBound);
            this.Level = 0;
            if (lpModel.basisValid == 0) {
                int n = 0;
                while (n <= lpModel.rows) {
                    lpModel.basis[n] = 1;
                    lpModel.bas[n] = n;
                    ++n;
                }
                n = lpModel.rows + 1;
                while (n <= lpModel.sum) {
                    lpModel.basis[n] = 0;
                    ++n;
                }
                n = 0;
                while (n <= lpModel.sum) {
                    lpModel.lower[n] = 1;
                    ++n;
                }
                lpModel.basisValid = 1;
            }
            lpModel.etaValid = 0;
            this.Break_bb = 0;
            int n = this.milpsolve(lpModel, lpModel.origUpperBound, lpModel.origLowerBound, lpModel.basis, lpModel.lower, lpModel.bas, 0);
            return n;
        }
        this.print("Error, the current LP seems to be invalid\n");
        return 4;
    }

    int lagrangianSolve(LpModel lpModel, double d, int n, int n2) throws Exception {
        double d2;
        double d3;
        double[] dArray = new double[lpModel.columns + 1];
        double[] dArray2 = new double[lpModel.columns + 1];
        double[] dArray3 = new double[lpModel.nrLagrange];
        double[] dArray4 = new double[lpModel.sum + 1];
        int[] nArray = new int[lpModel.rows];
        System.arraycopy(lpModel.bas, 0, nArray, 0, lpModel.rows + 1);
        int[] nArray2 = new int[lpModel.sum + 1];
        System.arraycopy(lpModel.lower, 0, nArray2, 0, lpModel.rows + 1);
        lpModel.getRow(0, dArray);
        double d4 = 2.0;
        if (lpModel.maximise != 0) {
            d3 = 1.0E24;
            d2 = d;
        } else {
            d2 = -1.0E24;
            d3 = d;
        }
        int n3 = 5;
        double d5 = 1.0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 < lpModel.nrLagrange) {
            lpModel.lambda[n6] = 0.0;
            ++n6;
        }
        while (n3 == 5) {
            int n7;
            ++n5;
            n6 = 1;
            while (n6 <= lpModel.columns) {
                dArray2[n6] = dArray[n6];
                n7 = 0;
                while (n7 < lpModel.nrLagrange) {
                    if (lpModel.maximise != 0) {
                        int n8 = n6;
                        dArray2[n8] = dArray2[n8] - lpModel.lambda[n7] * lpModel.lagRow[n7][n6];
                    } else {
                        int n9 = n6;
                        dArray2[n9] = dArray2[n9] + lpModel.lambda[n7] * lpModel.lagRow[n7][n6];
                    }
                    ++n7;
                }
                ++n6;
            }
            n6 = 1;
            while (n6 <= lpModel.columns) {
                lpModel.setMatrixElement(0, n6, dArray2[n6]);
                ++n6;
            }
            double d6 = 0.0;
            n6 = 0;
            while (n6 < lpModel.nrLagrange) {
                d6 = lpModel.maximise != 0 ? (d6 += lpModel.lambda[n6] * lpModel.lagRhs[n6]) : (d6 -= lpModel.lambda[n6] * lpModel.lagRhs[n6]);
                ++n6;
            }
            if (n2 != 0) {
                this.println("Zub: " + d3 + " Zlb: " + d2 + " Step: " + d5 + " pie: " + d4 + " Feas " + n4);
                n6 = 0;
                while (n6 < lpModel.nrLagrange) {
                    this.println(n6 + " SubGrad " + dArray3[n6] + " lambda " + lpModel.lambda[n6]);
                    ++n6;
                }
            }
            if (n2 != 0 && lpModel.sum < 20) {
                lpModel.printLp();
            }
            int n10 = this.solve(lpModel);
            if (n2 != 0 && lpModel.sum < 20) {
                lpModel.printSolution();
            }
            int n11 = 1;
            n6 = 1;
            while (n11 != 0 && n6 < lpModel.rows) {
                n11 = nArray[n6] == lpModel.bas[n6] ? 1 : 0;
                ++n6;
            }
            n6 = 1;
            while (n11 != 0 && n6 < lpModel.sum) {
                n11 = nArray2[n6] == lpModel.lower[n6] ? 1 : 0;
                ++n6;
            }
            if (n11 == 0) {
                System.arraycopy(lpModel.lower, 0, nArray2, 0, lpModel.sum + 1);
                System.arraycopy(lpModel.bas, 0, nArray, 0, lpModel.rows + 1);
                d4 *= 0.95;
            }
            if (n2 != 0) {
                this.println("result: " + n10 + "  same basis: " + n11);
            }
            if (n10 == 3) {
                n6 = 1;
                while (n6 <= lpModel.columns) {
                    this.print(dArray2[n6] + " ");
                    ++n6;
                }
                throw new Exception("Unbounded!");
            }
            if (n10 == 4) {
                n3 = 4;
            }
            if (n10 == 2) {
                n3 = 2;
            }
            double d7 = 0.0;
            n6 = 0;
            while (n6 < lpModel.nrLagrange) {
                dArray3[n6] = -lpModel.lagRhs[n6];
                n7 = 1;
                while (n7 <= lpModel.columns) {
                    int n12 = n6;
                    dArray3[n12] = dArray3[n12] + lpModel.bestSolution[lpModel.rows + n7] * lpModel.lagRow[n6][n7];
                    ++n7;
                }
                d7 += dArray3[n6] * dArray3[n6];
                ++n6;
            }
            n4 = 1;
            n6 = 0;
            while (n6 < lpModel.nrLagrange) {
                if (lpModel.lagConType[n6] != 0) {
                    if (Math.abs(dArray3[n6]) > lpModel.epsb) {
                        n4 = 0;
                    }
                } else if (dArray3[n6] > lpModel.epsb) {
                    n4 = 0;
                }
                ++n6;
            }
            if (n4 != 0) {
                bl = true;
                double d8 = 0.0;
                n6 = 1;
                while (n6 <= lpModel.columns) {
                    d8 += lpModel.bestSolution[lpModel.rows + n6] * dArray[n6];
                    ++n6;
                }
                if (lpModel.maximise != 0 && d8 > d2) {
                    d2 = d8;
                    n6 = 1;
                    while (n6 <= lpModel.sum) {
                        dArray4[n6] = lpModel.bestSolution[n6];
                        ++n6;
                    }
                    dArray4[0] = d2;
                    if (n2 != 0) {
                        this.print("Best feasible solution: " + d2 + "\n");
                    }
                } else if (d8 < d3) {
                    d3 = d8;
                    n6 = 1;
                    while (n6 <= lpModel.sum) {
                        dArray4[n6] = lpModel.bestSolution[n6];
                        ++n6;
                    }
                    dArray4[0] = d3;
                    if (n2 != 0) {
                        this.print("Best feasible solution: " + d3 + "\n");
                    }
                }
            }
            if (lpModel.maximise != 0) {
                d3 = Math.min(d3, d6 + lpModel.bestSolution[0]);
            } else {
                d2 = Math.max(d2, d6 + lpModel.bestSolution[0]);
            }
            if (Math.abs(d3 - d2) < 0.001) {
                n3 = 0;
            }
            d5 = d4 * (1.05 * d3 - d2) / d7;
            n6 = 0;
            while (n6 < lpModel.nrLagrange) {
                int n13 = n6;
                lpModel.lambda[n13] = lpModel.lambda[n13] + d5 * dArray3[n6];
                if (lpModel.lagConType[n6] == 0 && lpModel.lambda[n6] < 0.0) {
                    lpModel.lambda[n6] = 0.0;
                }
                ++n6;
            }
            if (n5 != n || n3 != 5) continue;
            n3 = bl ? 6 : 7;
        }
        n6 = 0;
        while (n6 <= lpModel.sum) {
            lpModel.bestSolution[n6] = dArray4[n6];
            ++n6;
        }
        n6 = 1;
        while (n6 <= lpModel.columns) {
            lpModel.setMatrixElement(0, n6, dArray[n6]);
            ++n6;
        }
        lpModel.lagBound = lpModel.maximise != 0 ? d3 : d2;
        return n3;
    }

    void println(String string) {
        if (this.viewer != null) {
            this.viewer.messageln(string);
        } else {
            System.out.println(string);
        }
    }

    void print(String string) {
        if (this.viewer != null) {
            this.viewer.message(string);
        } else {
            System.out.print(string);
        }
    }
}

