/*
 * Decompiled with CFR 0.152.
 */
package briefj.opt;

import briefj.opt.IOUtils;
import briefj.opt.OrderedMap;
import briefj.opt.StrUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class OrderedStringMap
extends OrderedMap<String, String> {
    public OrderedStringMap() {
    }

    public OrderedStringMap(OrderedStringMap map) {
        for (String key : map.keys()) {
            this.put(key, map.get(key));
        }
    }

    public static OrderedStringMap fromFile(String path) throws IOException {
        return OrderedStringMap.fromFile(new File(path));
    }

    public static OrderedStringMap fromFile(File path) throws IOException {
        OrderedStringMap map = new OrderedStringMap();
        map.read(path);
        return map;
    }

    @Override
    public void put(String key, Object val) {
        super.put(key, StrUtils.toString(val));
    }

    public void read(String path) throws IOException {
        this.read(new File(path));
    }

    public void read(File path) throws IOException {
        BufferedReader in = IOUtils.openIn(path);
        this.read(in);
        in.close();
    }

    public void read(BufferedReader r) throws IOException {
        String line;
        this.clear();
        while ((line = r.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, "\t");
            if (!st.hasMoreTokens()) continue;
            String key = st.nextToken();
            String val = st.hasMoreTokens() ? st.nextToken() : null;
            this.put(key, val);
        }
    }

    public boolean readEasy(String path) {
        if (StrUtils.isEmpty(path)) {
            return false;
        }
        return this.readEasy(new File(path));
    }

    public boolean readEasy(File path) {
        if (path == null) {
            return false;
        }
        try {
            this.read(path);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void readHard(String path) {
        this.readHard(new File(path));
    }

    public void readHard(File path) {
        try {
            this.read(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

