/*
 * Decompiled with CFR 0.152.
 */
package org.forester.protein;

import java.util.ArrayList;
import java.util.List;
import org.forester.go.GoId;
import org.forester.util.ForesterUtil;

public class DomainId
implements Comparable<DomainId> {
    private final String _id;
    private List<GoId> _go_ids;

    public DomainId(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to create domain id from empty or null string");
        }
        this._id = string.trim();
        if (this._id.indexOf(32) > -1) {
            throw new IllegalArgumentException("attempt to create domain id from string containing one ore more spaces [" + this._id + "]");
        }
        if (this._id.indexOf("=") > -1) {
            throw new IllegalArgumentException("attempt to create domain id from string containing the separator character [=] for domain combinations [" + this._id + "]");
        }
        this.setGoIds(null);
    }

    public void addGoId(GoId goId) {
        if (this.getGoIds() == null) {
            this.setGoIds(new ArrayList<GoId>());
        }
        this.getGoIds().add(goId);
    }

    @Override
    public int compareTo(DomainId domainId) {
        if (this == domainId) {
            return 0;
        }
        return this.getId().toLowerCase().compareTo(domainId.getId().toLowerCase());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.getId().equals(((DomainId)object).getId());
    }

    public GoId getGoId(int n) {
        return this.getGoIds().get(n);
    }

    public List<GoId> getGoIds() {
        return this._go_ids;
    }

    public String getId() {
        return this._id;
    }

    public int getNumberOfGoIds() {
        if (this.getGoIds() == null) {
            return 0;
        }
        return this.getGoIds().size();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private void setGoIds(List<GoId> list) {
        this._go_ids = list;
    }

    public String toString() {
        return this.getId();
    }
}

