/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Control;
import JSci.instruments.DummyPositionControl;
import JSci.instruments.Image;
import JSci.instruments.ImageFilterAdapter;
import JSci.instruments.PTCroquetteCross;
import JSci.instruments.ParticleTracker;
import JSci.instruments.ParticleTrackerListener;
import JSci.instruments.Player;
import JSci.instruments.PositionControl;
import JSci.instruments.ROI;
import JSci.instruments.Simulated;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

public class PTCroquette
extends ImageFilterAdapter
implements ParticleTracker,
ROI {
    public static int CROSS_L = 32;
    public static int CROSS_H = 3;
    public static double CALIBR_STEP = 0.5;
    public static int CALIBR_AVR = 3;
    private PTCroquetteCross cross1;
    private PTCroquetteCross cross2;
    private PositionControl pc = null;
    private ParticleTrackerListener ptl = null;
    private Component mouseComponent;
    private boolean calibrating = false;
    private PTControlComponent controlComponent;
    private Point refPos = new Point();

    public String getName() {
        return "PT 3D symmetric";
    }

    public void setListener(ParticleTrackerListener particleTrackerListener) {
        this.ptl = particleTrackerListener;
    }

    public PTCroquette(PositionControl positionControl) {
        this.cross1 = new PTCroquetteCross(CROSS_L, CROSS_H, new Point(50, 50), Color.MAGENTA);
        this.cross2 = new PTCroquetteCross(CROSS_L, CROSS_H, new Point(50, 120), Color.CYAN);
        this.pc = positionControl;
        this.controlComponent = new PTControlComponent(new Control[]{this.pc, this.cross1, this.cross2});
        this.pc.addChangeListener((ChangeListener)((Object)this.cross1.getControlComponent()));
        this.pc.addChangeListener((ChangeListener)((Object)this.cross2.getControlComponent()));
        this.controlComponent = new PTControlComponent(new Control[]{this.pc, this.cross1, this.cross2});
    }

    public void filter(Image image) {
        this.cross1.setBBox(new Rectangle(new Point(0, 0), this.getSize()));
        this.cross2.setBBox(new Rectangle(new Point(0, 0), this.getSize()));
        this.cross1.findXY(image);
        this.cross2.findXY(image);
        if (!this.calibrating) {
            this.cross1.findZ(image);
            this.cross2.findZ(image);
        } else {
            this.cross1.calibrationSendImage(image);
            this.cross2.calibrationSendImage(image);
        }
        if (this.ptl != null) {
            this.ptl.receivePosition(image.getTimeStamp(), new int[]{0, 1}, new double[]{this.cross1.getLocation().getX(), this.cross2.getLocation().getX()}, new double[]{this.cross1.getLocation().getY(), this.cross2.getLocation().getY()}, new double[]{this.cross1.getZ() - this.pc.getPosition(), this.cross2.getZ() - this.pc.getPosition()});
        }
    }

    public Shape getShape() {
        return this.cross2;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.cross1.getColor());
        graphics2D.draw(this.cross1);
        Point2D point2D = this.cross1.getLocation();
        graphics2D.drawString("Ref", (int)point2D.getX() + CROSS_H, (int)point2D.getY() + CROSS_L);
        graphics2D.setColor(this.cross2.getColor());
        graphics2D.draw(this.cross2);
    }

    public void setComponent(Component component) {
        this.mouseComponent = component;
        component.addMouseListener(new MouseHandler());
        component.addMouseMotionListener(new MouseMotionHandler());
        component.addMouseWheelListener(new MouseWheelHandler());
    }

    private void doCalibration(int n, int n2, double d, double d2) {
        if (n <= 0 || d >= d2) {
            return;
        }
        this.calibrating = true;
        this.cross1.calibrationStart(n, d, d2);
        this.cross2.calibrationStart(n, d, d2);
        for (int i = 0; i < n; ++i) {
            this.pc.setPosition((double)i * (d2 - d) / (double)n + d);
            this.pc.sleep();
            for (int j = 0; j < n2; ++j) {
                this.cross1.calibrationRequest(i);
                this.cross2.calibrationRequest(i);
                this.cross1.calibrationWait();
                this.cross2.calibrationWait();
            }
        }
        this.cross1.calibrationEnd();
        this.cross2.calibrationEnd();
        this.calibrating = false;
    }

    public Component getFilterControlComponent() {
        return this.controlComponent;
    }

    public static void main(String[] stringArray) {
        DummyPositionControl dummyPositionControl = new DummyPositionControl(){

            protected void doSetPosition(double d) {
                Simulated.z = d;
                super.doSetPosition(d);
            }
        };
        Simulated.z = dummyPositionControl.getPosition();
        PTCroquette pTCroquette = new PTCroquette(dummyPositionControl);
        Simulated simulated = new Simulated();
        Player player = new Player();
        player.addROI(pTCroquette);
        simulated.setSink(pTCroquette);
        pTCroquette.setSink(player);
        player.start();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(4);
        ParticleTrackerListener particleTrackerListener = new ParticleTrackerListener(){

            public void receivePosition(long l, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3) {
                System.out.println(l + " " + dArray[0] + " " + dArray2[0] + " " + dArray3[0] + " " + dArray[1] + " " + dArray2[1] + " " + dArray3[1]);
            }
        };
        pTCroquette.setListener(particleTrackerListener);
    }

    private class MouseWheelHandler
    implements MouseWheelListener {
        private MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (PTCroquette.this.calibrating) {
                return;
            }
            double d = PTCroquette.this.pc.getPosition();
            PTCroquette.this.pc.setPosition(d -= (double)mouseWheelEvent.getWheelRotation() * 0.1);
        }
    }

    private class MouseMotionHandler
    extends MouseMotionAdapter {
        private MouseMotionHandler() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (PTCroquette.this.cross1.getBounds().contains(mouseEvent.getPoint()) || PTCroquette.this.cross2.getBounds().contains(mouseEvent.getPoint())) {
                PTCroquette.this.mouseComponent.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                PTCroquette.this.mouseComponent.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (PTCroquette.this.cross1.isDragging()) {
                PTCroquette.this.cross1.setLocation(new Point(mouseEvent.getPoint().x + ((PTCroquette)PTCroquette.this).refPos.x, mouseEvent.getPoint().y + ((PTCroquette)PTCroquette.this).refPos.y));
            }
            if (PTCroquette.this.cross2.isDragging()) {
                PTCroquette.this.cross2.setLocation(new Point(mouseEvent.getPoint().x + ((PTCroquette)PTCroquette.this).refPos.x, mouseEvent.getPoint().y + ((PTCroquette)PTCroquette.this).refPos.y));
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (PTCroquette.this.cross1.getBounds().contains(mouseEvent.getPoint())) {
                PTCroquette.this.cross1.setDragging(true);
                PTCroquette.this.refPos = new Point((int)PTCroquette.this.cross1.getLocation().getX(), (int)PTCroquette.this.cross1.getLocation().getY());
            } else if (PTCroquette.this.cross2.getBounds().contains(mouseEvent.getPoint())) {
                PTCroquette.this.cross2.setDragging(true);
                PTCroquette.this.refPos = new Point((int)PTCroquette.this.cross2.getLocation().getX(), (int)PTCroquette.this.cross2.getLocation().getY());
            }
            PTCroquette.this.refPos.translate(-mouseEvent.getPoint().x, -mouseEvent.getPoint().y);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            PTCroquette.this.cross1.setDragging(false);
            PTCroquette.this.cross2.setDragging(false);
        }
    }

    private class PTControlComponent
    extends JPanel {
        private JButton calibrButton = new JButton("Calibrate");
        private JButton setMin = new JButton("Set min");
        private JButton setMax = new JButton("Set max");
        private JSpinner calibrMin = new JSpinner(new SpinnerNumberModel(0.0, PTCroquette.access$300(PTCroquette.this).getMinimum(), PTCroquette.access$300(PTCroquette.this).getMaximum(), 0.1));
        private JSpinner calibrMax = new JSpinner(new SpinnerNumberModel(0.0, PTCroquette.access$300(PTCroquette.this).getMinimum(), PTCroquette.access$300(PTCroquette.this).getMaximum(), 0.1));

        public PTControlComponent(Control[] controlArray) {
            for (int i = 0; i < controlArray.length; ++i) {
                this.add(controlArray[i].getControlComponent());
            }
            this.add(this.calibrButton);
            this.calibrButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            PTControlComponent.this.calibrButton.setEnabled(false);
                            PTCroquette.this.pc.getControlComponent().setEnabled(false);
                            double d = (Double)PTControlComponent.this.calibrMin.getValue();
                            double d2 = (Double)PTControlComponent.this.calibrMax.getValue();
                            PTCroquette.this.doCalibration((int)Math.round((d2 - d) / CALIBR_STEP), CALIBR_AVR, d, d2);
                            PTCroquette.this.pc.getControlComponent().setEnabled(true);
                            PTControlComponent.this.calibrButton.setEnabled(true);
                        }
                    });
                    thread.start();
                }
            });
            this.setMin.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PTControlComponent.this.calibrMin.setValue(new Double(PTCroquette.this.pc.getPosition()));
                }
            });
            this.setMax.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PTControlComponent.this.calibrMax.setValue(new Double(PTCroquette.this.pc.getPosition()));
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel.add("North", this.setMax);
            jPanel2.add("North", this.calibrMax);
            jPanel.add("South", this.setMin);
            jPanel2.add("South", this.calibrMin);
            this.add(jPanel);
            this.add(jPanel2);
        }
    }
}

