/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DoubleFileSquareMatrix
extends AbstractDoubleSquareMatrix {
    private static final int DEFAULT_ROW_BUFFERS = 3;
    private static final boolean DEFAULT_DIAG_BUFFER = true;
    private static final int DOUBLE_BYTE_SIZE = 8;
    private final RandomAccessFile file;
    private final int[] rowHistory;
    private final int[] colHistory;
    private final int[] bufferRows;
    private final int[] bufferStartCols;
    private final int[] bufferEndCols;
    private final double[][] buffers;
    private final double[] diagBuffer;

    public DoubleFileSquareMatrix(int n, File file, int n2, boolean bl) throws IOException {
        this(n, file, n2, bl, null);
    }

    private DoubleFileSquareMatrix(int n, File file, int n2, boolean bl, double[][] dArray) throws IOException {
        super(n);
        int n3;
        this.rowHistory = new int[n2];
        this.colHistory = new int[n2];
        this.bufferRows = new int[n2];
        this.bufferStartCols = new int[n2];
        this.bufferEndCols = new int[n2];
        this.buffers = new double[n2][];
        for (n3 = 0; n3 < this.buffers.length; ++n3) {
            this.rowHistory[n3] = -1;
            this.colHistory[n3] = -1;
            this.bufferRows[n3] = -1;
            this.bufferStartCols[n3] = -1;
            this.bufferEndCols[n3] = -1;
        }
        this.diagBuffer = bl ? new double[n] : null;
        this.file = new RandomAccessFile(file, "rw");
        if (dArray != null) {
            for (n3 = 0; n3 < n; ++n3) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.numCols * 8);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeDouble(dArray[n3][i]);
                }
                dataOutputStream.close();
                this.file.write(byteArrayOutputStream.toByteArray());
                if (!bl) continue;
                this.diagBuffer[n3] = dArray[n3][n3];
            }
        } else {
            for (n3 = 0; n3 < n; ++n3) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.numCols * 8);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeDouble(0.0);
                }
                dataOutputStream.close();
                this.file.write(byteArrayOutputStream.toByteArray());
            }
        }
    }

    public DoubleFileSquareMatrix(int n, String string, int n2, boolean bl) throws IOException {
        this(n, new File(string), n2, bl);
    }

    private DoubleFileSquareMatrix(int n, double[][] dArray) throws IOException {
        this(n, DoubleFileSquareMatrix.createTempMatrixFile(), 3, true, dArray);
    }

    private static File createTempMatrixFile() throws IOException {
        File file = File.createTempFile("jsci", ".matrix");
        file.deleteOnExit();
        return file;
    }

    public DoubleFileSquareMatrix(int n) throws IOException {
        this(n, null);
    }

    public DoubleFileSquareMatrix(double[][] dArray) throws IOException {
        this(dArray.length, dArray);
    }

    private void writeBuffer(int n) throws IOException {
        if (this.bufferRows[n] != -1 && this.buffers[n] != null) {
            int n2 = this.bufferStartCols[n];
            int n3 = this.bufferEndCols[n];
            this.seek(this.bufferRows[n], n2);
            int n4 = n3 - n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n4 * 8);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (int i = n2; i < n3; ++i) {
                dataOutputStream.writeDouble(this.buffers[n][i]);
            }
            dataOutputStream.close();
            this.file.write(byteArrayOutputStream.toByteArray());
        }
    }

    private void readBuffer(int n, int n2, int n3, int n4) throws IOException {
        if (this.buffers[n] == null) {
            this.buffers[n] = new double[this.numCols];
        }
        this.seek(n2, n3);
        int n5 = n4 - n3;
        byte[] byArray = new byte[n5 * 8];
        this.file.readFully(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        for (int i = n3; i < n4; ++i) {
            this.buffers[n][i] = dataInputStream.readDouble();
        }
        dataInputStream.close();
    }

    private double[] buffer(int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        this.writeBuffer(this.buffers.length - 1);
        double[] dArray = this.buffers[this.buffers.length - 1];
        System.arraycopy(this.buffers, 0, this.buffers, 1, this.buffers.length - 1);
        System.arraycopy(this.bufferRows, 0, this.bufferRows, 1, this.bufferRows.length - 1);
        System.arraycopy(this.bufferStartCols, 0, this.bufferStartCols, 1, this.bufferStartCols.length - 1);
        System.arraycopy(this.bufferEndCols, 0, this.bufferEndCols, 1, this.bufferEndCols.length - 1);
        this.buffers[0] = dArray;
        if (n2 >= n3) {
            n5 = n2;
            n4 = this.numCols;
        } else {
            n5 = 0;
            n4 = n2 + 1;
        }
        this.readBuffer(0, n, n5, n4);
        this.bufferRows[0] = n;
        this.bufferStartCols[0] = n5;
        this.bufferEndCols[0] = n4;
        return this.buffers[0];
    }

    private double[] extendBuffer(int n, int n2, int n3) throws IOException {
        int n4 = this.bufferStartCols[n];
        int n5 = this.bufferEndCols[n];
        if (n3 < n4) {
            this.readBuffer(n, n2, n3, n4);
            this.bufferStartCols[n] = n3;
        } else if (n3 >= n5) {
            this.readBuffer(n, n2, n5, n3 + 1);
            this.bufferEndCols[n] = n3 + 1;
        }
        return this.buffers[n];
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            double d;
            if (n == n2 && this.diagBuffer != null) {
                d = this.diagBuffer[n];
            } else {
                int n3 = DoubleFileSquareMatrix.find(this.bufferRows, n);
                if (n3 != -1) {
                    try {
                        d = this.extendBuffer(n3, n, n2)[n2];
                    }
                    catch (IOException iOException) {
                        throw new MatrixDimensionException(iOException.toString());
                    }
                }
                int n4 = DoubleFileSquareMatrix.find(this.rowHistory, n);
                if (n4 != -1) {
                    try {
                        int n5 = this.colHistory[n4];
                        d = this.buffer(n, n2, n5)[n2];
                    }
                    catch (IOException iOException) {
                        throw new MatrixDimensionException(iOException.toString());
                    }
                }
                try {
                    d = this.read(n, n2);
                }
                catch (IOException iOException) {
                    throw new MatrixDimensionException(iOException.toString());
                }
            }
            this.updateHistory(n, n2);
            return d;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2 && this.diagBuffer != null) {
                this.diagBuffer[n] = d;
            } else {
                int n3 = DoubleFileSquareMatrix.find(this.bufferRows, n);
                if (n3 != -1) {
                    try {
                        this.extendBuffer((int)n3, (int)n, (int)n2)[n2] = d;
                    }
                    catch (IOException iOException) {
                        throw new MatrixDimensionException(iOException.toString());
                    }
                } else {
                    int n4 = DoubleFileSquareMatrix.find(this.rowHistory, n);
                    if (n4 != -1) {
                        try {
                            int n5 = this.colHistory[n4];
                            this.buffer((int)n, (int)n2, (int)n5)[n2] = d;
                        }
                        catch (IOException iOException) {
                            throw new MatrixDimensionException(iOException.toString());
                        }
                    } else {
                        try {
                            this.write(n, n2, d);
                        }
                        catch (IOException iOException) {
                            throw new MatrixDimensionException(iOException.toString());
                        }
                    }
                }
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.updateHistory(n, n2);
    }

    private void seek(int n, int n2) throws IOException {
        long l = ((long)n * (long)this.numCols + (long)n2) * 8L;
        this.file.seek(l);
    }

    private double read(int n, int n2) throws IOException {
        this.seek(n, n2);
        return this.file.readDouble();
    }

    private void write(int n, int n2, double d) throws IOException {
        this.seek(n, n2);
        this.file.writeDouble(d);
    }

    private void updateHistory(int n, int n2) {
        if (this.rowHistory.length > 0) {
            System.arraycopy(this.rowHistory, 0, this.rowHistory, 1, this.rowHistory.length - 1);
            System.arraycopy(this.colHistory, 0, this.colHistory, 1, this.colHistory.length - 1);
            this.rowHistory[0] = n;
            this.colHistory[0] = n2;
        }
    }

    public void close() throws IOException {
        int n;
        for (n = 0; n < this.buffers.length; ++n) {
            this.writeBuffer(n);
        }
        if (this.diagBuffer != null) {
            for (n = 0; n < this.numRows; ++n) {
                this.write(n, n, this.diagBuffer[n]);
            }
        }
        this.file.close();
    }

    private static int find(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }
}

