/*
 * Decompiled with CFR 0.152.
 */
package conifer.clock.proposals;

import conifer.clock.ClockTree;
import conifer.clock.proposals.ClockTreeProposal;
import fig.basic.Pair;
import goblin.Taxon;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import nuts.math.Sampling;
import nuts.util.CollUtils;
import nuts.util.Counter;

public class NarrowExchangeProposal
implements ClockTreeProposal {
    @Override
    public String description() {
        return "NarrowExchangeProposal";
    }

    @Override
    public Pair<ClockTree, Double> propose(Random rand, ClockTree tree) {
        Counter<Set<Taxon>> internalHeights = tree.internalHeights();
        for (Set<Taxon> tax : CollUtils.set(internalHeights.keySet())) {
            if (tax.size() >= 3) continue;
            internalHeights.removeKey(tax);
        }
        Set<Taxon> selected = ClockTree.sample(internalHeights, rand);
        Set<Taxon> tallChild = tree.tallChild(selected);
        Set<Taxon> shortChild = tree.shortChild(selected);
        Set<Taxon> tallGrandChild = tree.tallChild(tallChild);
        Set<Taxon> shortGrandChild = tree.shortChild(tallChild);
        Set<Taxon> pickedGrandChild = Sampling.sampleBern(0.5, rand) ? tallGrandChild : shortGrandChild;
        HashMap<Set<Taxon>, Double> newHeights = CollUtils.map(tree.getHeights());
        double tallChildHeight = tree.height(tallChild);
        newHeights.remove(tallChild);
        Set newTallChildNode = CollUtils.union(pickedGrandChild, shortChild);
        newHeights.put(newTallChildNode, tallChildHeight);
        return Pair.makePair(new ClockTree(newHeights), 0.0);
    }
}

