/*
 * Decompiled with CFR 0.152.
 */
package conifer.msa;

import ev.hmm.HetPairHMM;
import goblin.Taxon;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.CounterMap;

public class InformedProposal {
    final List<Integer> ambiguousPositions;
    final CounterMap<Integer, Integer> probabilities;
    final Taxon src;
    final Taxon dest;

    public static InformedProposal create(Taxon l1, Taxon l2, String s1, String s2, HetPairHMM hmm, boolean flipped, double threshold) {
        HashSet<Integer> ambiguous = new HashSet<Integer>();
        CounterMap<Integer, Integer> map = new CounterMap<Integer, Integer>();
        for (int p1 = 0; p1 < s1.length(); ++p1) {
            Counter<Integer> edgePosteriors = new Counter<Integer>();
            for (int p2 = 0; p2 < s2.length(); ++p2) {
                edgePosteriors.setCount(p2, Math.exp(hmm.logPosteriorAlignment(flipped ? p2 : p1, flipped ? p1 : p2)));
            }
            double noAlignPost = 1.0 - edgePosteriors.totalCount();
            edgePosteriors.setCount(-1, noAlignPost);
            double cum = 0.0;
            for (Integer p : edgePosteriors) {
                double curPost = edgePosteriors.getCount(p);
                map.setCount(p1, p, curPost);
                if (!((cum += curPost) >= threshold)) continue;
                break;
            }
            if (map.getCounter(p1).size() <= 1) continue;
            ambiguous.add(p1);
        }
        return new InformedProposal(map, l1, l2, ambiguous);
    }

    public InformedProposal(CounterMap<Integer, Integer> probabilities, Taxon src, Taxon dest, Set<Integer> ambiguousPos) {
        this.probabilities = probabilities;
        this.ambiguousPositions = CollUtils.list(ambiguousPos);
        this.src = src;
        this.dest = dest;
    }
}

