/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.Integral;
import dr.math.MathUtils;
import dr.math.UnivariateFunction;

public class MonteCarloIntegral
implements Integral {
    private int sampleSize;

    public MonteCarloIntegral(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    public double integrate(UnivariateFunction f, double min, double max) {
        double integral = 0.0;
        double range = max - min;
        for (int i = 1; i <= this.sampleSize; ++i) {
            integral += f.evaluate(MathUtils.nextDouble() * range + min);
        }
        return integral *= range / (double)this.sampleSize;
    }
}

